/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import java.util.Objects;
import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;

public class IsJsonNumber
extends AbstractJsonNodeMatcher<NumericNode> {
    private final Matcher<?> numberMatcher;
    private final Function<NumericNode, Object> projection;

    private IsJsonNumber(Matcher<?> numberMatcher, Function<NumericNode, Object> projection) {
        super(JsonNodeType.NUMBER);
        this.numberMatcher = Objects.requireNonNull(numberMatcher);
        this.projection = Objects.requireNonNull(projection);
    }

    public static Matcher<JsonNode> jsonNumber() {
        return new IsJsonNumber(IsAnything.anything(), n -> n);
    }

    public static Matcher<JsonNode> jsonInt(int number) {
        return new IsJsonNumber(Is.is((Object)number), NumericNode::asInt);
    }

    public static Matcher<JsonNode> jsonInt(Matcher<? super Integer> numberMatcher) {
        return new IsJsonNumber(numberMatcher, NumericNode::asInt);
    }

    public static Matcher<JsonNode> jsonLong(long number) {
        return new IsJsonNumber(Is.is((Object)number), NumericNode::asLong);
    }

    public static Matcher<JsonNode> jsonLong(Matcher<? super Long> numberMatcher) {
        return new IsJsonNumber(numberMatcher, NumericNode::asLong);
    }

    public static Matcher<JsonNode> jsonDouble(double number) {
        return new IsJsonNumber(Is.is((Object)number), NumericNode::asDouble);
    }

    public static Matcher<JsonNode> jsonDouble(Matcher<? super Double> numberMatcher) {
        return new IsJsonNumber(numberMatcher, NumericNode::asDouble);
    }

    @Override
    protected boolean matchesNode(NumericNode node, Description mismatchDescription) {
        Object number = this.projection.apply(node);
        if (this.numberMatcher.matches(number)) {
            return true;
        }
        mismatchDescription.appendText("was a number node ");
        this.numberMatcher.describeMismatch(number, mismatchDescription);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a number node ").appendDescriptionOf(this.numberMatcher);
    }
}

