/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import com.spotify.hamcrest.util.DescriptionUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class IsJsonObject
extends AbstractJsonNodeMatcher<ObjectNode> {
    private final ImmutableMap<String, Matcher<? super JsonNode>> entryMatchers;

    private IsJsonObject(ImmutableMap<String, Matcher<? super JsonNode>> entryMatchers) {
        super(JsonNodeType.OBJECT);
        this.entryMatchers = Objects.requireNonNull(entryMatchers);
    }

    public static IsJsonObject jsonObject() {
        return new IsJsonObject((ImmutableMap<String, Matcher<? super JsonNode>>)ImmutableMap.of());
    }

    public IsJsonObject where(String key, Matcher<? super JsonNode> valueMatcher) {
        return new IsJsonObject((ImmutableMap<String, Matcher<? super JsonNode>>)ImmutableMap.builder().putAll(this.entryMatchers).put((Object)key, valueMatcher).build());
    }

    @Override
    protected boolean matchesNode(ObjectNode node, Description mismatchDescription) {
        for (Map.Entry entryMatcher : this.entryMatchers.entrySet()) {
            JsonNode value;
            String key = (String)entryMatcher.getKey();
            Matcher valueMatcher = (Matcher)entryMatcher.getValue();
            if (valueMatcher.matches((Object)(value = node.path(key)))) continue;
            IsJsonObject.describeKey(key, mismatchDescription, d -> valueMatcher.describeMismatch((Object)value, d));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("{\n");
        for (Map.Entry entryMatcher : this.entryMatchers.entrySet()) {
            String key = (String)entryMatcher.getKey();
            Matcher valueMatcher = (Matcher)entryMatcher.getValue();
            description.appendText("  ").appendText(IsJsonObject.jsonEscapeString(key)).appendText(": ");
            StringDescription innerDescription = new StringDescription();
            valueMatcher.describeTo((Description)innerDescription);
            DescriptionUtils.indentDescription((Description)description, (Description)innerDescription);
        }
        description.appendText("}");
    }

    static void describeKey(String key, Description mismatchDescription, Consumer<Description> innerAction) {
        mismatchDescription.appendText("{\n  ...\n  ").appendText(IsJsonObject.jsonEscapeString(key)).appendText(": ");
        StringDescription innerDescription = new StringDescription();
        innerAction.accept((Description)innerDescription);
        DescriptionUtils.indentDescription((Description)mismatchDescription, (Description)innerDescription);
        mismatchDescription.appendText("  ...\n}");
    }

    static String jsonEscapeString(String string) {
        return JsonNodeFactory.instance.textNode(string).toString();
    }
}

