/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;

public class IsJsonText
extends AbstractJsonNodeMatcher<TextNode> {
    private final Matcher<? super String> textMatcher;

    private IsJsonText(Matcher<? super String> textMatcher) {
        super(JsonNodeType.STRING);
        this.textMatcher = Objects.requireNonNull(textMatcher);
    }

    public static Matcher<JsonNode> jsonText() {
        return new IsJsonText((Matcher<? super String>)Is.is((Matcher)IsAnything.anything()));
    }

    public static Matcher<JsonNode> jsonText(String text) {
        return new IsJsonText((Matcher<? super String>)Is.is((Object)text));
    }

    public static Matcher<JsonNode> jsonText(Matcher<? super String> textMatcher) {
        return new IsJsonText(textMatcher);
    }

    @Override
    protected boolean matchesNode(TextNode node, Description mismatchDescription) {
        String value = node.asText();
        if (this.textMatcher.matches((Object)value)) {
            return true;
        }
        mismatchDescription.appendText("was a text node with value that ");
        this.textMatcher.describeMismatch((Object)value, mismatchDescription);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a text node with value that ").appendDescriptionOf(this.textMatcher);
    }
}

