/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsAnything;

public class IsJsonBoolean
extends AbstractJsonNodeMatcher<BooleanNode> {
    private final Matcher<? super Boolean> booleanMatcher;

    private IsJsonBoolean(Matcher<? super Boolean> booleanMatcher) {
        super(JsonNodeType.BOOLEAN);
        this.booleanMatcher = Objects.requireNonNull(booleanMatcher);
    }

    public static Matcher<JsonNode> jsonBoolean() {
        return new IsJsonBoolean((Matcher<? super Boolean>)Is.is((Matcher)IsAnything.anything()));
    }

    public static Matcher<JsonNode> jsonBoolean(boolean bool) {
        return new IsJsonBoolean((Matcher<? super Boolean>)Is.is((Object)bool));
    }

    public static Matcher<JsonNode> jsonBoolean(Matcher<? super Boolean> booleanMatcher) {
        return new IsJsonBoolean(booleanMatcher);
    }

    @Override
    protected boolean matchesNode(BooleanNode node, Description mismatchDescription) {
        boolean value = node.asBoolean();
        if (this.booleanMatcher.matches((Object)value)) {
            return true;
        }
        mismatchDescription.appendText("was a boolean node with value that ");
        this.booleanMatcher.describeMismatch((Object)value, mismatchDescription);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a boolean node with value that ").appendDescriptionOf(this.booleanMatcher);
    }
}

