/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import com.spotify.hamcrest.util.DescriptionUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class IsJsonObject
extends AbstractJsonNodeMatcher<ObjectNode> {
    private final LinkedHashMap<String, Matcher<? super JsonNode>> entryMatchers;

    private IsJsonObject(LinkedHashMap<String, Matcher<? super JsonNode>> entryMatchers) {
        super(JsonNodeType.OBJECT);
        this.entryMatchers = Objects.requireNonNull(entryMatchers);
    }

    public static IsJsonObject jsonObject() {
        return new IsJsonObject(new LinkedHashMap<String, Matcher<? super JsonNode>>());
    }

    public IsJsonObject where(String key, Matcher<? super JsonNode> valueMatcher) {
        LinkedHashMap<String, Matcher<? super JsonNode>> newMap = new LinkedHashMap<String, Matcher<? super JsonNode>>(this.entryMatchers);
        newMap.put(key, valueMatcher);
        return new IsJsonObject(newMap);
    }

    @Override
    protected boolean matchesNode(ObjectNode node, Description mismatchDescription) {
        LinkedHashMap<String, Consumer<Description>> mismatchedKeys = new LinkedHashMap<String, Consumer<Description>>();
        for (Map.Entry<String, Matcher<? super JsonNode>> entryMatcher : this.entryMatchers.entrySet()) {
            JsonNode value;
            String key = entryMatcher.getKey();
            Matcher<? super JsonNode> valueMatcher = entryMatcher.getValue();
            if (valueMatcher.matches((Object)(value = node.path(key)))) continue;
            mismatchedKeys.put(key, d -> valueMatcher.describeMismatch((Object)value, d));
        }
        if (!mismatchedKeys.isEmpty()) {
            DescriptionUtils.describeNestedMismatches(this.entryMatchers.keySet(), (Description)mismatchDescription, mismatchedKeys, IsJsonObject::describeKey);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("{\n");
        for (Map.Entry<String, Matcher<? super JsonNode>> entryMatcher : this.entryMatchers.entrySet()) {
            String key = entryMatcher.getKey();
            Matcher<? super JsonNode> valueMatcher = entryMatcher.getValue();
            description.appendText("  ");
            IsJsonObject.describeKey(key, description);
            description.appendText(": ");
            StringDescription innerDescription = new StringDescription();
            valueMatcher.describeTo((Description)innerDescription);
            DescriptionUtils.indentDescription((Description)description, (Description)innerDescription);
        }
        description.appendText("}");
    }

    private static void describeKey(String key, Description mismatchDescription) {
        mismatchDescription.appendText(IsJsonObject.jsonEscapeString(key));
    }

    private static String jsonEscapeString(String string) {
        return JsonNodeFactory.instance.textNode(string).toString();
    }
}

