/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import org.hamcrest.Condition;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class IsJsonStringMatching
extends TypeSafeDiagnosingMatcher<String> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Matcher<JsonNode> matcher;

    public static Matcher<String> isJsonStringMatching(Matcher<JsonNode> matcher) {
        return new IsJsonStringMatching(matcher);
    }

    private IsJsonStringMatching(Matcher<JsonNode> matcher) {
        this.matcher = Objects.requireNonNull(matcher, "matcher");
    }

    protected boolean matchesSafely(String string, Description description) {
        return this.parseJsonNode(string, description).matching(this.matcher);
    }

    private Condition<JsonNode> parseJsonNode(String string, Description mismatchDescription) {
        if (string == null) {
            mismatchDescription.appendText(" but JSON string was null");
            return Condition.notMatched();
        }
        try {
            JsonNode jsonNode = MAPPER.readTree(string);
            return Condition.matched((Object)jsonNode, (Description)mismatchDescription);
        }
        catch (IOException e) {
            mismatchDescription.appendText(" but the string was not valid JSON ").appendValue((Object)e.getMessage());
            return Condition.notMatched();
        }
    }

    public void describeTo(Description description) {
        description.appendText("A JSON string that matches ").appendDescriptionOf(this.matcher);
    }
}

