/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.spotify.hamcrest.util.LanguageUtils;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public abstract class AbstractJsonNodeMatcher<A extends JsonNode>
extends TypeSafeDiagnosingMatcher<JsonNode> {
    private final JsonNodeType type;

    AbstractJsonNodeMatcher(JsonNodeType type) {
        super(JsonNode.class);
        this.type = Objects.requireNonNull(type);
    }

    protected boolean matchesSafely(JsonNode item, Description mismatchDescription) {
        if (item.getNodeType() == this.type) {
            JsonNode node = item;
            return this.matchesNode(node, mismatchDescription);
        }
        mismatchDescription.appendText("was not ").appendText(LanguageUtils.addArticle((String)this.type.name().toLowerCase())).appendText(" node, but ").appendText(LanguageUtils.addArticle((String)item.getNodeType().name().toLowerCase())).appendText(" node");
        return false;
    }

    protected abstract boolean matchesNode(A var1, Description var2);
}

