/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.spotify.hamcrest.jackson.AbstractJsonNodeMatcher;
import com.spotify.hamcrest.jackson.IsJsonArray;
import com.spotify.hamcrest.jackson.IsJsonBoolean;
import com.spotify.hamcrest.jackson.IsJsonMissing;
import com.spotify.hamcrest.jackson.IsJsonNull;
import com.spotify.hamcrest.jackson.IsJsonNumber;
import com.spotify.hamcrest.jackson.IsJsonText;
import com.spotify.hamcrest.util.DescriptionUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class IsJsonObject
extends AbstractJsonNodeMatcher<ObjectNode> {
    private final LinkedHashMap<String, Matcher<? super JsonNode>> entryMatchers;

    private IsJsonObject(LinkedHashMap<String, Matcher<? super JsonNode>> entryMatchers) {
        super(JsonNodeType.OBJECT);
        this.entryMatchers = Objects.requireNonNull(entryMatchers);
    }

    public static IsJsonObject jsonObject() {
        return new IsJsonObject(new LinkedHashMap<String, Matcher<? super JsonNode>>());
    }

    public static IsJsonObject jsonObject(ObjectNode objectNode) {
        Iterator fields = objectNode.fields();
        LinkedHashMap<String, Matcher<? super JsonNode>> entryMatchers = new LinkedHashMap<String, Matcher<? super JsonNode>>();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            entryMatchers.put((String)field.getKey(), (Matcher<? super JsonNode>)IsJsonObject.createNodeMatcher((JsonNode)field.getValue()));
        }
        return new IsJsonObject(entryMatchers);
    }

    private static Matcher<JsonNode> createNodeMatcher(JsonNode value) {
        JsonNodeType nodeType = value.getNodeType();
        switch (nodeType) {
            case ARRAY: {
                return IsJsonArray.jsonArray((ArrayNode)value);
            }
            case BINARY: {
                throw new UnsupportedOperationException("Expected value contains a binary node, which is not implemented.");
            }
            case BOOLEAN: {
                return IsJsonBoolean.jsonBoolean((BooleanNode)value);
            }
            case MISSING: {
                return IsJsonMissing.jsonMissing((MissingNode)value);
            }
            case NULL: {
                return IsJsonNull.jsonNull((NullNode)value);
            }
            case NUMBER: {
                return IsJsonNumber.jsonNumber((NumericNode)value);
            }
            case OBJECT: {
                return IsJsonObject.jsonObject((ObjectNode)value);
            }
            case POJO: {
                throw new UnsupportedOperationException("Expected value contains a POJO node, which is not implemented.");
            }
            case STRING: {
                return IsJsonText.jsonText((TextNode)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported node type " + nodeType);
    }

    public IsJsonObject where(String key, Matcher<? super JsonNode> valueMatcher) {
        LinkedHashMap<String, Matcher<? super JsonNode>> newMap = new LinkedHashMap<String, Matcher<? super JsonNode>>(this.entryMatchers);
        newMap.put(key, valueMatcher);
        return new IsJsonObject(newMap);
    }

    @Override
    protected boolean matchesNode(ObjectNode node, Description mismatchDescription) {
        LinkedHashMap<String, Consumer<Description>> mismatchedKeys = new LinkedHashMap<String, Consumer<Description>>();
        for (Map.Entry<String, Matcher<? super JsonNode>> entryMatcher : this.entryMatchers.entrySet()) {
            JsonNode value;
            String key = entryMatcher.getKey();
            Matcher<? super JsonNode> valueMatcher = entryMatcher.getValue();
            if (valueMatcher.matches((Object)(value = node.path(key)))) continue;
            mismatchedKeys.put(key, d -> valueMatcher.describeMismatch((Object)value, d));
        }
        if (!mismatchedKeys.isEmpty()) {
            DescriptionUtils.describeNestedMismatches(this.entryMatchers.keySet(), (Description)mismatchDescription, mismatchedKeys, IsJsonObject::describeKey);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("{\n");
        for (Map.Entry<String, Matcher<? super JsonNode>> entryMatcher : this.entryMatchers.entrySet()) {
            String key = entryMatcher.getKey();
            Matcher<? super JsonNode> valueMatcher = entryMatcher.getValue();
            description.appendText("  ");
            IsJsonObject.describeKey(key, description);
            description.appendText(": ");
            StringDescription innerDescription = new StringDescription();
            valueMatcher.describeTo((Description)innerDescription);
            DescriptionUtils.indentDescription((Description)description, (Description)innerDescription);
        }
        description.appendText("}");
    }

    private static void describeKey(String key, Description mismatchDescription) {
        mismatchDescription.appendText(IsJsonObject.jsonEscapeString(key));
    }

    private static String jsonEscapeString(String string) {
        return JsonNodeFactory.instance.textNode(string).toString();
    }
}

