/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.optional;

import com.spotify.hamcrest.optional.EmptyOptional;
import com.spotify.hamcrest.optional.PresentOptional;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public final class OptionalMatchers {
    private OptionalMatchers() {
    }

    public static <T> Matcher<Optional<T>> emptyOptional() {
        return new EmptyOptional();
    }

    public static Matcher<Optional<?>> optionalWithValue() {
        return OptionalMatchers.optionalWithValue(CoreMatchers.anything());
    }

    public static <T> Matcher<Optional<? extends T>> optionalWithValue(T value) {
        return OptionalMatchers.optionalWithValue(CoreMatchers.equalTo(value));
    }

    public static <T> Matcher<Optional<? extends T>> optionalWithValue(Matcher<T> matcher) {
        return new PresentOptional<T>(matcher);
    }
}

