/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.JobId;

public class Deployment
extends Descriptor {
    private final JobId jobId;
    private final Goal goal;

    public Deployment(@JsonProperty(value="job") JobId jobId, @JsonProperty(value="goal") Goal goal) {
        this.jobId = jobId;
        this.goal = goal;
    }

    public static Deployment of(JobId jobId, Goal goal) {
        return Deployment.newBuilder().setJobId(jobId).setGoal(goal).build();
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public String toString() {
        return this.jobId + "|" + (Object)((Object)this.goal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deployment that = (Deployment)o;
        if (this.goal != that.goal) {
            return false;
        }
        return !(this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null);
    }

    public int hashCode() {
        int result = this.jobId != null ? this.jobId.hashCode() : 0;
        result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private JobId jobId;
        private Goal goal;

        public Builder setJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setGoal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public Deployment build() {
            return new Deployment(this.jobId, this.goal);
        }
    }
}

