/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

public class DockerVersion {
    private final String apiVersion;
    private final String arch;
    private final String gitCommit;
    private final String goVersion;
    private final String kernelVersion;
    private final String os;
    private final String version;

    public DockerVersion(@JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="arch") String arch, @JsonProperty(value="gitCommit") String gitCommit, @JsonProperty(value="goVersion") String goVersion, @JsonProperty(value="kernelVersion") String kernelVersion, @JsonProperty(value="os") String os, @JsonProperty(value="version") String version) {
        this.apiVersion = apiVersion;
        this.arch = arch;
        this.gitCommit = gitCommit;
        this.goVersion = goVersion;
        this.kernelVersion = kernelVersion;
        this.os = os;
        this.version = version;
    }

    private DockerVersion(Builder builder) {
        this.apiVersion = builder.apiVersion;
        this.arch = builder.arch;
        this.gitCommit = builder.gitCommit;
        this.goVersion = builder.goVersion;
        this.kernelVersion = builder.kernelVersion;
        this.os = builder.os;
        this.version = builder.version;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getArch() {
        return this.arch;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGoVersion() {
        return this.goVersion;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public String getOs() {
        return this.os;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerVersion that = (DockerVersion)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.arch != null ? !this.arch.equals(that.arch) : that.arch != null) {
            return false;
        }
        if (this.gitCommit != null ? !this.gitCommit.equals(that.gitCommit) : that.gitCommit != null) {
            return false;
        }
        if (this.goVersion != null ? !this.goVersion.equals(that.goVersion) : that.goVersion != null) {
            return false;
        }
        if (this.kernelVersion != null ? !this.kernelVersion.equals(that.kernelVersion) : that.kernelVersion != null) {
            return false;
        }
        if (this.os != null ? !this.os.equals(that.os) : that.os != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.apiVersion != null ? this.apiVersion.hashCode() : 0;
        result = 31 * result + (this.arch != null ? this.arch.hashCode() : 0);
        result = 31 * result + (this.gitCommit != null ? this.gitCommit.hashCode() : 0);
        result = 31 * result + (this.goVersion != null ? this.goVersion.hashCode() : 0);
        result = 31 * result + (this.kernelVersion != null ? this.kernelVersion.hashCode() : 0);
        result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("apiVersion", (Object)this.apiVersion).add("arch", (Object)this.arch).add("gitCommit", (Object)this.gitCommit).add("goVersion", (Object)this.goVersion).add("kernelVersion", (Object)this.kernelVersion).add("os", (Object)this.os).add("version", (Object)this.version).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiVersion;
        private String arch;
        private String gitCommit;
        private String goVersion;
        private String kernelVersion;
        private String os;
        private String version;

        private Builder() {
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        public Builder gitCommit(String gitCommit) {
            this.gitCommit = gitCommit;
            return this;
        }

        public Builder goVersion(String goVersion) {
            this.goVersion = goVersion;
            return this;
        }

        public Builder kernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public DockerVersion build() {
            return new DockerVersion(this);
        }
    }
}

