/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import com.spotify.helios.common.Hash;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Job
extends Descriptor
implements Comparable<Job> {
    public static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    public static final Map<String, PortMapping> EMPTY_PORTS = Collections.emptyMap();
    public static final List<String> EMPTY_COMMAND = Collections.emptyList();
    public static final Map<ServiceEndpoint, ServicePorts> EMPTY_REGISTRATION = Collections.emptyMap();
    public static final Integer EMPTY_GRACE_PERIOD = null;
    public static final Map<String, String> EMPTY_VOLUMES = Collections.emptyMap();
    public static final String EMPTY_MOUNT = "";
    public static final Date EMPTY_EXPIRES = null;
    public static final String EMPTY_REGISTRATION_DOMAIN = "";
    private final JobId id;
    private final String image;
    private final List<String> command;
    private final Map<String, String> env;
    private final Map<String, PortMapping> ports;
    private final Map<ServiceEndpoint, ServicePorts> registration;
    private final Integer gracePeriod;
    private final Map<String, String> volumes;
    private final Date expires;
    private final String registrationDomain;

    public Job(@JsonProperty(value="id") JobId id, @JsonProperty(value="image") String image, @JsonProperty(value="command") @Nullable List<String> command, @JsonProperty(value="env") @Nullable Map<String, String> env, @JsonProperty(value="ports") @Nullable Map<String, PortMapping> ports, @JsonProperty(value="registration") @Nullable Map<ServiceEndpoint, ServicePorts> registration, @JsonProperty(value="gracePeriod") @Nullable Integer gracePeriod, @JsonProperty(value="volumes") @Nullable Map<String, String> volumes, @JsonProperty(value="expires") @Nullable Date expires, @JsonProperty(value="registrationDomain") @Nullable String registrationDomain) {
        this.id = id;
        this.image = image;
        this.command = (List)Optional.fromNullable(command).or(EMPTY_COMMAND);
        this.env = (Map)Optional.fromNullable(env).or(EMPTY_ENV);
        this.ports = (Map)Optional.fromNullable(ports).or(EMPTY_PORTS);
        this.registration = (Map)Optional.fromNullable(registration).or(EMPTY_REGISTRATION);
        this.gracePeriod = (Integer)Optional.fromNullable((Object)gracePeriod).orNull();
        this.volumes = (Map)Optional.fromNullable(volumes).or(EMPTY_VOLUMES);
        this.expires = expires;
        this.registrationDomain = (String)Optional.fromNullable((Object)registrationDomain).or((Object)"");
    }

    private Job(JobId id, Builder.Parameters p) {
        this.id = id;
        this.image = p.image;
        this.command = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(p.command, (Object)"command")));
        this.env = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.env, (Object)"env")));
        this.ports = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.ports, (Object)"ports")));
        this.registration = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.registration, (Object)"registration")));
        this.gracePeriod = p.gracePeriod;
        this.volumes = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(p.volumes, (Object)"volumes")));
        this.expires = p.expires;
        this.registrationDomain = (String)Optional.fromNullable((Object)p.registrationDomain).or((Object)"");
    }

    public JobId getId() {
        return this.id;
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, PortMapping> getPorts() {
        return this.ports;
    }

    public Map<ServiceEndpoint, ServicePorts> getRegistration() {
        return this.registration;
    }

    public String getRegistrationDomain() {
        return this.registrationDomain;
    }

    public Integer getGracePeriod() {
        return this.gracePeriod;
    }

    public Map<String, String> getVolumes() {
        return this.volumes;
    }

    public Date getExpires() {
        return this.expires;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int compareTo(Job o) {
        return this.id.compareTo(o.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.command != null ? !this.command.equals(job.command) : job.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(job.env) : job.env != null) {
            return false;
        }
        if (this.expires != null ? !this.expires.equals(job.expires) : job.expires != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(job.id) : job.id != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(job.image) : job.image != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(job.ports) : job.ports != null) {
            return false;
        }
        if (this.registration != null ? !this.registration.equals(job.registration) : job.registration != null) {
            return false;
        }
        if (this.registrationDomain != null ? !this.registrationDomain.equals(job.registrationDomain) : job.registrationDomain != null) {
            return false;
        }
        if (this.gracePeriod != null ? !this.gracePeriod.equals(job.gracePeriod) : job.gracePeriod != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(job.volumes) : job.volumes != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.expires != null ? this.expires.hashCode() : 0);
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        result = 31 * result + (this.registration != null ? this.registration.hashCode() : 0);
        result = 31 * result + (this.registrationDomain != null ? this.registrationDomain.hashCode() : 0);
        result = 31 * result + (this.gracePeriod != null ? this.gracePeriod.hashCode() : 0);
        result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("image", (Object)this.image).add("command", this.command).add("env", this.env).add("ports", this.ports).add("registration", this.registration).add("gracePeriod", (Object)this.gracePeriod).add("expires", (Object)this.expires).add("registrationDomain", (Object)this.registrationDomain).toString();
    }

    public Builder toBuilder() {
        Builder builder = Job.newBuilder();
        if (this.id != null) {
            builder.setName(this.id.getName()).setVersion(this.id.getVersion());
        }
        return builder.setImage(this.image).setCommand(this.command).setEnv(this.env).setPorts(this.ports).setRegistration(this.registration).setGracePeriod(this.gracePeriod).setVolumes(this.volumes).setExpires(this.expires).setRegistrationDomain(this.registrationDomain);
    }

    public static class Builder
    implements Cloneable {
        private final Parameters p;
        private String hash;

        private Builder() {
            this.p = new Parameters();
        }

        public Builder(String hash, Parameters parameters) {
            this.hash = hash;
            this.p = parameters;
        }

        public Builder setRegistrationDomain(String domain) {
            this.p.registrationDomain = domain;
            return this;
        }

        public Builder setHash(String hash) {
            this.hash = hash;
            return this;
        }

        public Builder setName(String name) {
            this.p.name = name;
            return this;
        }

        public Builder setVersion(String version) {
            this.p.version = version;
            return this;
        }

        public Builder setImage(String image) {
            this.p.image = image;
            return this;
        }

        public Builder setCommand(List<String> command) {
            this.p.command = ImmutableList.copyOf(command);
            return this;
        }

        public Builder setEnv(Map<String, String> env) {
            this.p.env = Maps.newHashMap(env);
            return this;
        }

        public Builder addEnv(String key, String value) {
            this.p.env.put(key, value);
            return this;
        }

        public Builder setPorts(Map<String, PortMapping> ports) {
            this.p.ports = Maps.newHashMap(ports);
            return this;
        }

        public Builder addPort(String name, PortMapping port) {
            this.p.ports.put(name, port);
            return this;
        }

        public Builder setRegistration(Map<ServiceEndpoint, ServicePorts> registration) {
            this.p.registration = Maps.newHashMap(registration);
            return this;
        }

        public Builder addRegistration(ServiceEndpoint endpoint, ServicePorts ports) {
            this.p.registration.put(endpoint, ports);
            return this;
        }

        public Builder setGracePeriod(Integer gracePeriod) {
            this.p.gracePeriod = gracePeriod;
            return this;
        }

        public Builder setVolumes(Map<String, String> volumes) {
            this.p.volumes = Maps.newHashMap(volumes);
            return this;
        }

        public Builder addVolume(String path) {
            this.p.volumes.put(path, "");
            return this;
        }

        public Builder addVolume(String path, String source) {
            this.p.volumes.put(path, source);
            return this;
        }

        public Builder setExpires(Date expires) {
            this.p.expires = expires;
            return this;
        }

        public String getName() {
            return this.p.name;
        }

        public String getVersion() {
            return this.p.version;
        }

        public String getImage() {
            return this.p.image;
        }

        public List<String> getCommand() {
            return this.p.command;
        }

        public Map<String, String> getEnv() {
            return ImmutableMap.copyOf(this.p.env);
        }

        public Map<String, PortMapping> getPorts() {
            return ImmutableMap.copyOf(this.p.ports);
        }

        public Map<ServiceEndpoint, ServicePorts> getRegistration() {
            return ImmutableMap.copyOf(this.p.registration);
        }

        public String getRegistrationDomain() {
            return this.p.registrationDomain;
        }

        public Integer getGracePeriod() {
            return this.p.gracePeriod;
        }

        public Map<String, String> getVolumes() {
            return ImmutableMap.copyOf(this.p.volumes);
        }

        public Date getExpires() {
            return this.p.expires;
        }

        public Builder clone() {
            return new Builder(this.hash, new Parameters(this.p));
        }

        public Job build() {
            String hash;
            String configHash;
            try {
                configHash = this.hex(Json.sha1digest(this.p));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            if (this.p.name != null && this.p.version != null) {
                String input = String.format("%s:%s:%s", this.p.name, this.p.version, configHash);
                hash = this.hex(Hash.sha1digest(input.getBytes(Charsets.UTF_8)));
                if (this.hash != null) {
                    Preconditions.checkArgument((boolean)this.hash.equals(hash));
                }
            } else {
                hash = null;
            }
            JobId id = new JobId(this.p.name, this.p.version, hash);
            return new Job(id, this.p);
        }

        private String hex(byte[] bytes) {
            return BaseEncoding.base16().lowerCase().encode(bytes);
        }

        private static class Parameters
        implements Cloneable {
            public String registrationDomain;
            public String name;
            public String version;
            public String image;
            public List<String> command;
            public Map<String, String> env;
            public Map<String, PortMapping> ports;
            public Map<ServiceEndpoint, ServicePorts> registration;
            public Integer gracePeriod;
            public Map<String, String> volumes;
            public Date expires;

            private Parameters() {
                this.command = EMPTY_COMMAND;
                this.env = Maps.newHashMap(EMPTY_ENV);
                this.ports = Maps.newHashMap(EMPTY_PORTS);
                this.registration = Maps.newHashMap(EMPTY_REGISTRATION);
                this.gracePeriod = EMPTY_GRACE_PERIOD;
                this.volumes = Maps.newHashMap(EMPTY_VOLUMES);
                this.registrationDomain = "";
            }

            private Parameters(Parameters p) {
                this.name = p.name;
                this.version = p.version;
                this.image = p.image;
                this.command = ImmutableList.copyOf(p.command);
                this.env = Maps.newHashMap(p.env);
                this.ports = Maps.newHashMap(p.ports);
                this.registration = Maps.newHashMap(p.registration);
                this.gracePeriod = p.gracePeriod;
                this.volumes = Maps.newHashMap(p.volumes);
                this.expires = p.expires;
                this.registrationDomain = p.registrationDomain;
            }
        }
    }
}

