/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.spotify.helios.common.descriptors.HealthCheck;

public class ExecHealthCheck
extends HealthCheck {
    private final String command;

    public ExecHealthCheck(@JsonProperty(value="command") String command) {
        super("exec");
        this.command = command;
    }

    private ExecHealthCheck(Builder builder) {
        super("exec");
        this.command = builder.command;
    }

    public String getCommand() {
        return this.command;
    }

    public static ExecHealthCheck of(String command) {
        return ExecHealthCheck.newBuilder().setCommand(command).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecHealthCheck that = (ExecHealthCheck)o;
        return !(this.command != null ? !this.command.equals(that.command) : that.command != null);
    }

    public int hashCode() {
        int result = this.command != null ? this.command.hashCode() : 0;
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("command", (Object)this.command).toString();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String command;

        public String getCommand() {
            return this.command;
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public ExecHealthCheck build() {
            if (Strings.isNullOrEmpty((String)this.command)) {
                throw new IllegalArgumentException("You must specify a command for an exec health check.");
            }
            return new ExecHealthCheck(this);
        }
    }
}

