/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ThrottleState;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TaskStatus
extends Descriptor {
    private static final Map<String, PortMapping> EMPTY_PORTS = Collections.emptyMap();
    private final Job job;
    private final Goal goal;
    private final State state;
    private final String containerId;
    private final ThrottleState throttled;
    private final Map<String, PortMapping> ports;
    private final Map<String, String> env;

    public TaskStatus(@JsonProperty(value="job") Job job, @JsonProperty(value="goal") @Nullable Goal goal, @JsonProperty(value="state") State state, @JsonProperty(value="containerId") @Nullable String containerId, @JsonProperty(value="throttled") ThrottleState throttled, @JsonProperty(value="ports") Map<String, PortMapping> ports, @JsonProperty(value="env") @Nullable Map<String, String> env) {
        this.job = (Job)Preconditions.checkNotNull((Object)job, (Object)"job");
        this.goal = goal;
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.containerId = containerId;
        this.throttled = (ThrottleState)((Object)Optional.fromNullable((Object)((Object)throttled)).or((Object)ThrottleState.NO));
        this.ports = (Map)Optional.fromNullable(ports).or(EMPTY_PORTS);
        this.env = (Map)Optional.fromNullable(env).or((Object)Maps.newHashMap());
    }

    public Builder asBuilder() {
        return TaskStatus.newBuilder().setJob(this.job).setGoal(this.goal).setState(this.state).setContainerId(this.containerId).setThrottled(this.throttled).setPorts(this.ports).setEnv(this.env);
    }

    private TaskStatus(Builder builder) {
        this.job = (Job)Preconditions.checkNotNull((Object)builder.job, (Object)"job");
        this.goal = (Goal)((Object)Preconditions.checkNotNull((Object)((Object)builder.goal), (Object)"goal"));
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)builder.state), (Object)"state"));
        this.containerId = builder.containerId;
        this.throttled = (ThrottleState)((Object)Optional.fromNullable((Object)((Object)builder.throttled)).or((Object)ThrottleState.NO));
        this.ports = (Map)Optional.fromNullable((Object)builder.ports).or(EMPTY_PORTS);
        this.env = (Map)Optional.fromNullable((Object)builder.env).or((Object)Maps.newHashMap());
    }

    public ThrottleState getThrottled() {
        return this.throttled;
    }

    @Nullable
    public String getContainerId() {
        return this.containerId;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public State getState() {
        return this.state;
    }

    public Job getJob() {
        return this.job;
    }

    public Map<String, PortMapping> getPorts() {
        return this.ports;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("job", (Object)this.job).add("goal", (Object)this.goal).add("state", (Object)this.state).add("containerId", (Object)this.containerId).add("throttled", (Object)this.throttled).add("ports", this.ports).add("env", this.env).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatus that = (TaskStatus)o;
        if (this.containerId != null ? !this.containerId.equals(that.containerId) : that.containerId != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.goal != that.goal) {
            return false;
        }
        if (this.job != null ? !this.job.equals(that.job) : that.job != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        return this.throttled == that.throttled;
    }

    public int hashCode() {
        int result = this.job != null ? this.job.hashCode() : 0;
        result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.containerId != null ? this.containerId.hashCode() : 0);
        result = 31 * result + (this.throttled != null ? this.throttled.hashCode() : 0);
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Job job;
        private Goal goal;
        private State state;
        private String containerId;
        private Map<String, PortMapping> ports;
        private ThrottleState throttled;
        private Map<String, String> env;

        Builder() {
        }

        public Builder setJob(Job job) {
            this.job = job;
            return this;
        }

        public Builder setGoal(Goal goal) {
            this.goal = goal;
            return this;
        }

        public Builder setState(State state) {
            this.state = state;
            return this;
        }

        public Builder setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder setPorts(Map<String, PortMapping> ports) {
            this.ports = ports;
            return this;
        }

        public Builder setThrottled(ThrottleState throttled) {
            this.throttled = throttled;
            return this;
        }

        public Builder setEnv(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public TaskStatus build() {
            return new TaskStatus(this);
        }
    }

    public static enum State {
        PULLING_IMAGE,
        CREATING,
        STARTING,
        HEALTHCHECKING,
        RUNNING,
        EXITED,
        STOPPING,
        STOPPED,
        FAILED,
        UNKNOWN;

    }
}

