/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.context;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.spotify.helios.common.context.CallPathToExecutorException;
import com.spotify.helios.common.context.ContextCallable;
import com.spotify.helios.common.context.ContextExecutorService;
import com.spotify.helios.common.context.ContextListeningExecutorService;
import com.spotify.helios.common.context.ContextListeningScheduledExecutorService;
import com.spotify.helios.common.context.ContextRunnable;
import com.spotify.helios.common.context.ContextScheduledExecutorService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public final class Context {
    private static final Field causeField;

    public static <T> Callable<T> makeContextCallable(Callable<T> in) {
        return new ContextCallable<T>(in);
    }

    public static Runnable makeContextRunnable(Runnable in) {
        return new ContextRunnable(in);
    }

    public static Executor decorate(final Executor executor) {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                executor.execute(Context.makeContextRunnable(command));
            }
        };
    }

    public static ExecutorService decorate(ExecutorService executorService) {
        return new ContextExecutorService(executorService);
    }

    public static ScheduledExecutorService decorate(ScheduledExecutorService service) {
        return new ContextScheduledExecutorService(service);
    }

    public static ListeningExecutorService decorate(ListeningExecutorService service) {
        return new ContextListeningExecutorService(service);
    }

    public static ListeningScheduledExecutorService decorate(ListeningScheduledExecutorService service) {
        return new ContextListeningScheduledExecutorService(service);
    }

    static void handleException(StackTraceElement[] trace, Throwable th) {
        if (causeField != null) {
            try {
                causeField.set(Context.findRootCause(th), new CallPathToExecutorException(trace));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    static StackTraceElement[] getStackContext() {
        return new Throwable().getStackTrace();
    }

    private static Throwable findRootCause(Throwable th) {
        while (th.getCause() != null) {
            th = th.getCause();
        }
        return th;
    }

    static <T> List<Callable<T>> makeContextWrappedCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList contexted = Lists.newArrayList();
        for (Callable<T> task : tasks) {
            contexted.add(Context.makeContextCallable(task));
        }
        return contexted;
    }

    static {
        Field fieldValue = null;
        try {
            fieldValue = Throwable.class.getDeclaredField("cause");
            fieldValue.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        causeField = fieldValue;
    }
}

