/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.RolloutTask;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeploymentGroupEvent
extends Descriptor {
    public static final String KAFKA_TOPIC = "HeliosDeploymentGroupEvents";
    private final RolloutTask.Action action;
    private final String target;
    private final RolloutTask.Status rolloutTaskStatus;
    private final DeploymentGroup deploymentGroup;
    private final DeploymentGroupStatus.State deploymentGroupState;
    private final long timestamp;

    public DeploymentGroupEvent(@JsonProperty(value="action") RolloutTask.Action action, @JsonProperty(value="target") String target, @JsonProperty(value="rolloutTaskStatus") RolloutTask.Status rolloutTaskStatus, @JsonProperty(value="deploymentGroup") DeploymentGroup deploymentGroup, @JsonProperty(value="deploymentGroupState") DeploymentGroupStatus.State deploymentGroupState, @JsonProperty(value="timestamp") long timestamp) {
        this.action = action;
        this.target = target;
        this.rolloutTaskStatus = rolloutTaskStatus;
        this.deploymentGroup = deploymentGroup;
        this.deploymentGroupState = deploymentGroupState;
        this.timestamp = timestamp;
    }

    private DeploymentGroupEvent(Builder builder) {
        this.deploymentGroup = (DeploymentGroup)Preconditions.checkNotNull((Object)builder.deploymentGroup);
        this.deploymentGroupState = (DeploymentGroupStatus.State)((Object)Preconditions.checkNotNull((Object)((Object)builder.deploymentGroupState)));
        this.action = builder.action;
        this.target = builder.target;
        this.rolloutTaskStatus = builder.rolloutTaskStatus;
        this.timestamp = builder.timestamp != null ? builder.timestamp : System.currentTimeMillis();
    }

    public RolloutTask.Action getAction() {
        return this.action;
    }

    public String getTarget() {
        return this.target;
    }

    public RolloutTask.Status getRolloutTaskStatus() {
        return this.rolloutTaskStatus;
    }

    public DeploymentGroup getDeploymentGroup() {
        return this.deploymentGroup;
    }

    public DeploymentGroupStatus.State getDeploymentGroupState() {
        return this.deploymentGroupState;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return Objects.toStringHelper(DeploymentGroupEvent.class).add("action", (Object)this.action).add("target", (Object)this.target).add("rolloutTaskStatus", (Object)this.rolloutTaskStatus).add("deploymentGroup", (Object)this.deploymentGroup).add("deploymentGroupState", (Object)this.deploymentGroupState).add("timestamp", this.timestamp).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroupEvent that = (DeploymentGroupEvent)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.action != that.action) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.rolloutTaskStatus != that.rolloutTaskStatus) {
            return false;
        }
        if (this.deploymentGroup != null ? !this.deploymentGroup.equals(that.deploymentGroup) : that.deploymentGroup != null) {
            return false;
        }
        return this.deploymentGroupState == that.deploymentGroupState;
    }

    public int hashCode() {
        int result = this.action != null ? this.action.hashCode() : 0;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.rolloutTaskStatus != null ? this.rolloutTaskStatus.hashCode() : 0);
        result = 31 * result + (this.deploymentGroup != null ? this.deploymentGroup.hashCode() : 0);
        result = 31 * result + (this.deploymentGroupState != null ? this.deploymentGroupState.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public static class Builder {
        private RolloutTask.Action action;
        private String target;
        private RolloutTask.Status rolloutTaskStatus;
        private DeploymentGroup deploymentGroup;
        private DeploymentGroupStatus.State deploymentGroupState;
        private Long timestamp;

        public Builder setAction(RolloutTask.Action action) {
            this.action = action;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setRolloutTaskStatus(RolloutTask.Status rolloutTaskStatus) {
            this.rolloutTaskStatus = rolloutTaskStatus;
            return this;
        }

        public Builder setDeploymentGroup(DeploymentGroup deploymentGroup) {
            this.deploymentGroup = deploymentGroup;
            return this;
        }

        public Builder setDeploymentGroupState(DeploymentGroupStatus.State deploymentGroupState) {
            this.deploymentGroupState = deploymentGroupState;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DeploymentGroupEvent build() {
            return new DeploymentGroupEvent(this);
        }
    }
}

