/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.protocol;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DeploymentGroupStatusResponse {
    private final DeploymentGroup deploymentGroup;
    private final Status status;
    private final String error;
    private final List<HostStatus> hostStatuses;
    private final DeploymentGroupStatus deploymentGroupStatus;

    public DeploymentGroupStatusResponse(@JsonProperty(value="deploymentGroup") DeploymentGroup deploymentGroup, @JsonProperty(value="status") Status status, @JsonProperty(value="error") String error, @JsonProperty(value="hostStatuses") List<HostStatus> hostStatuses, @JsonProperty(value="deploymentGroupStatus") @Nullable DeploymentGroupStatus dgs) {
        this.deploymentGroup = deploymentGroup;
        this.status = status;
        this.error = error;
        this.hostStatuses = hostStatuses;
        this.deploymentGroupStatus = dgs;
    }

    public DeploymentGroup getDeploymentGroup() {
        return this.deploymentGroup;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<HostStatus> getHostStatuses() {
        return this.hostStatuses;
    }

    public String getError() {
        return this.error;
    }

    public DeploymentGroupStatus getDeploymentGroupStatus() {
        return this.deploymentGroupStatus;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("deploymentGroup", (Object)this.deploymentGroup).add("status", (Object)this.status).add("error", (Object)this.error).add("hostStatuses", this.hostStatuses).add("deploymentGroupStatus", (Object)this.deploymentGroupStatus).toString();
    }

    public String toJsonString() {
        return Json.asStringUnchecked(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroupStatusResponse response = (DeploymentGroupStatusResponse)o;
        if (this.deploymentGroup != null ? !this.deploymentGroup.equals(response.deploymentGroup) : response.deploymentGroup != null) {
            return false;
        }
        if (this.deploymentGroupStatus != null ? !this.deploymentGroupStatus.equals(response.deploymentGroupStatus) : response.deploymentGroupStatus != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(response.error) : response.error != null) {
            return false;
        }
        if (this.hostStatuses != null ? !this.hostStatuses.equals(response.hostStatuses) : response.hostStatuses != null) {
            return false;
        }
        return this.status == response.status;
    }

    public int hashCode() {
        int result = this.deploymentGroup != null ? this.deploymentGroup.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.hostStatuses != null ? this.hostStatuses.hashCode() : 0);
        result = 31 * result + (this.deploymentGroupStatus != null ? this.deploymentGroupStatus.hashCode() : 0);
        return result;
    }

    public static class HostStatus {
        private final String host;
        private final JobId jobId;
        private final TaskStatus.State state;

        public HostStatus(@JsonProperty(value="host") String host, @JsonProperty(value="jobId") @Nullable JobId jobId, @JsonProperty(value="state") @Nullable TaskStatus.State state) {
            this.host = host;
            this.jobId = jobId;
            this.state = state;
        }

        public String getHost() {
            return this.host;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public TaskStatus.State getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostStatus that = (HostStatus)o;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
                return false;
            }
            if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
                return false;
            }
            return this.state == that.state;
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + (this.jobId != null ? this.jobId.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            return result;
        }
    }

    public static enum Status {
        ROLLING_OUT,
        ACTIVE,
        FAILED,
        IDLE;

    }
}

