/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.spotify.helios.client.HttpConnector;
import com.spotify.helios.client.RequestDispatcher;
import com.spotify.helios.client.Response;
import com.spotify.helios.common.Json;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestDispatcher.class);
    private final ListeningExecutorService executorService;
    private final HttpConnector httpConnector;
    private final boolean shutDownExecutorOnClose;

    DefaultRequestDispatcher(HttpConnector httpConnector, ListeningExecutorService executorService, boolean shutDownExecutorOnClose) {
        this.executorService = executorService;
        this.httpConnector = httpConnector;
        this.shutDownExecutorOnClose = shutDownExecutorOnClose;
    }

    @Override
    public ListenableFuture<Response> request(final URI uri, final String method, final byte[] entityBytes, final Map<String, List<String>> headers) {
        return this.executorService.submit((Callable)new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                HttpURLConnection connection = DefaultRequestDispatcher.this.httpConnector.connect(uri, method, entityBytes, headers);
                int status = connection.getResponseCode();
                InputStream rawStream = status / 100 != 2 ? connection.getErrorStream() : connection.getInputStream();
                boolean gzip = this.isGzipCompressed(connection);
                InputStream stream = gzip ? new GZIPInputStream(rawStream) : rawStream;
                ByteArrayOutputStream payload = new ByteArrayOutputStream();
                if (stream != null) {
                    int n;
                    byte[] buffer = new byte[4096];
                    while ((n = stream.read(buffer, 0, buffer.length)) != -1) {
                        payload.write(buffer, 0, n);
                    }
                }
                URI realUri = connection.getURL().toURI();
                if (log.isTraceEnabled()) {
                    log.trace("rep: {} {} {} {} {} gzip:{}", new Object[]{method, realUri, status, payload.size(), DefaultRequestDispatcher.this.decode(payload), gzip});
                } else {
                    log.debug("rep: {} {} {} {} gzip:{}", new Object[]{method, realUri, status, payload.size(), gzip});
                }
                return new Response(method, uri, status, payload.toByteArray(), Collections.unmodifiableMap(Maps.newHashMap(connection.getHeaderFields())));
            }

            private boolean isGzipCompressed(HttpURLConnection connection) {
                List<String> encodings = connection.getHeaderFields().get("Content-Encoding");
                if (encodings == null) {
                    return false;
                }
                for (String encoding : encodings) {
                    if (!"gzip".equals(encoding)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private String decode(ByteArrayOutputStream payload) {
        byte[] bytes = payload.toByteArray();
        try {
            return Json.asPrettyString(Json.read(bytes, new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shutDownExecutorOnClose) {
            this.executorService.shutdownNow();
        }
        this.httpConnector.close();
    }
}

