/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.spotify.helios.client.ClientCertificatePath;
import com.spotify.helios.client.HttpsHandler;
import com.spotify.helios.client.tls.X509CertificateFactory;
import com.spotify.sshagentproxy.AgentProxy;
import com.spotify.sshagentproxy.Identity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpsHandlers {
    HttpsHandlers() {
    }

    @VisibleForTesting
    protected static class CertificateAndPrivateKey {
        private final Certificate certificate;
        private final PrivateKey privateKey;

        public CertificateAndPrivateKey(Certificate certificate, PrivateKey privateKey) {
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        static CertificateAndPrivateKey from(X509CertificateFactory.CertificateAndKeyPair certificateAndKeyPair) {
            return new CertificateAndPrivateKey(certificateAndKeyPair.getCertificate(), certificateAndKeyPair.getKeyPair().getPrivate());
        }
    }

    protected static abstract class CertificateHttpsHandler
    implements HttpsHandler {
        private static final Logger log = LoggerFactory.getLogger(CertificateHttpsHandler.class);
        private static final char[] KEY_STORE_PASSWORD = "FPLSlZQuM3ZCM3SjINSKuWyPK2HeS4".toCharArray();
        private final String user;
        private final boolean failOnCertificateError;

        protected CertificateHttpsHandler(String user, boolean failOnCertificateError) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0);
            this.user = user;
            this.failOnCertificateError = failOnCertificateError;
        }

        @VisibleForTesting
        protected String getUser() {
            return this.user;
        }

        protected abstract CertificateAndPrivateKey createCertificateAndPrivateKey() throws IOException, GeneralSecurityException;

        protected abstract String getCertificateSource();

        @Override
        public void handle(HttpsURLConnection conn) {
            CertificateAndPrivateKey certificateAndPrivateKey;
            try {
                certificateAndPrivateKey = this.createCertificateAndPrivateKey();
            }
            catch (IOException | GeneralSecurityException e) {
                if (this.failOnCertificateError) {
                    throw Throwables.propagate((Throwable)e);
                }
                log.warn("Error when setting up client certificates from {}. Error was '{}'. No certificate will be sent with request.", (Object)this.getCertificateSource(), (Object)e.toString());
                log.debug("full exception from setting up ClientCertificate follows", (Throwable)e);
                return;
            }
            Certificate certificate = certificateAndPrivateKey.certificate;
            PrivateKey privateKey = certificateAndPrivateKey.privateKey;
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry("client", certificate);
                keyStore.setKeyEntry("key", privateKey, KEY_STORE_PASSWORD, new Certificate[]{certificate});
                SSLContext sslContext = SSLContexts.custom().useProtocol("TLS").loadKeyMaterial(keyStore, KEY_STORE_PASSWORD).build();
                conn.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    static class CertificateFileHttpsHandler
    extends CertificateHttpsHandler {
        private final ClientCertificatePath clientCertificatePath;

        CertificateFileHttpsHandler(String user, boolean failOnCertificateError, ClientCertificatePath clientCertificatePath) {
            super(user, failOnCertificateError);
            this.clientCertificatePath = (ClientCertificatePath)Preconditions.checkNotNull((Object)clientCertificatePath);
        }

        @VisibleForTesting
        protected ClientCertificatePath getClientCertificatePath() {
            return this.clientCertificatePath;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected CertificateAndPrivateKey createCertificateAndPrivateKey() throws IOException, GeneralSecurityException {
            void var5_5;
            PrivateKeyInfo keyInfo;
            Object parsedPem;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Path certPath = this.clientCertificatePath.getCertificatePath();
            try (InputStream is = Files.newInputStream(certPath, new OpenOption[0]);){
                Certificate certificate = cf.generateCertificate(is);
            }
            try (BufferedReader br = Files.newBufferedReader(this.clientCertificatePath.getKeyPath(), Charset.defaultCharset());){
                parsedPem = new PEMParser((Reader)br).readObject();
            }
            if (parsedPem instanceof PEMKeyPair) {
                keyInfo = ((PEMKeyPair)parsedPem).getPrivateKeyInfo();
            } else if (parsedPem instanceof PrivateKeyInfo) {
                keyInfo = (PrivateKeyInfo)parsedPem;
            } else {
                throw new UnsupportedOperationException("Unable to parse x509 certificate.");
            }
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyInfo.getEncoded());
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return new CertificateAndPrivateKey((Certificate)var5_5, kf.generatePrivate(spec));
        }

        @Override
        protected String getCertificateSource() {
            return this.clientCertificatePath.toString();
        }
    }

    static class SshAgentHttpsHandler
    extends CertificateHttpsHandler {
        private final AgentProxy agentProxy;
        private final Identity identity;

        SshAgentHttpsHandler(String user, boolean failOnCertificateError, AgentProxy agentProxy, Identity identity) {
            super(user, failOnCertificateError);
            this.agentProxy = (AgentProxy)Preconditions.checkNotNull((Object)agentProxy, (Object)"agentProxy");
            this.identity = (Identity)Preconditions.checkNotNull((Object)identity, (Object)"identity");
        }

        @VisibleForTesting
        protected AgentProxy getAgentProxy() {
            return this.agentProxy;
        }

        @VisibleForTesting
        protected Identity getIdentity() {
            return this.identity;
        }

        @Override
        protected CertificateAndPrivateKey createCertificateAndPrivateKey() {
            X509CertificateFactory.CertificateAndKeyPair certificateAndKeyPair = X509CertificateFactory.get(this.agentProxy, this.identity, this.getUser());
            return CertificateAndPrivateKey.from(certificateAndKeyPair);
        }

        @Override
        protected String getCertificateSource() {
            return "ssh-agent key: " + this.identity.getComment();
        }
    }
}

