/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import com.spotify.helios.client.RequestDispatcher;
import com.spotify.helios.client.Response;
import com.spotify.helios.common.Clock;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryingRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RetryingRequestDispatcher.class);
    private static final long RETRY_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private final ListeningScheduledExecutorService executorService;
    private final RequestDispatcher delegate;
    private final Clock clock;
    private final long delay;
    private final TimeUnit delayTimeUnit;

    RetryingRequestDispatcher(RequestDispatcher delegate, ListeningScheduledExecutorService executorService, Clock clock, long delay, TimeUnit delayTimeUnit) {
        this.delegate = delegate;
        this.executorService = executorService;
        this.clock = clock;
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
    }

    @Override
    public ListenableFuture<Response> request(final URI uri, final String method, final byte[] entityBytes, final Map<String, List<String>> headers) {
        long deadline = this.clock.now().getMillis() + RETRY_TIMEOUT_MILLIS;
        SettableFuture future = SettableFuture.create();
        Supplier<ListenableFuture<Response>> code = new Supplier<ListenableFuture<Response>>(){

            public ListenableFuture<Response> get() {
                return RetryingRequestDispatcher.this.delegate.request(uri, method, entityBytes, headers);
            }
        };
        this.startRetry((SettableFuture<Response>)future, code, deadline, this.delay, this.delayTimeUnit);
        return future;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void startRetry(final SettableFuture<Response> future, final Supplier<ListenableFuture<Response>> code, final long deadline, final long delay, final TimeUnit timeUnit) {
        ListenableFuture codeFuture;
        try {
            codeFuture = (ListenableFuture)code.get();
        }
        catch (Exception e) {
            this.handleFailure(future, code, deadline, delay, timeUnit, e);
            return;
        }
        Futures.addCallback((ListenableFuture)codeFuture, (FutureCallback)new FutureCallback<Response>(){

            public void onSuccess(Response result) {
                future.set((Object)result);
            }

            public void onFailure(@NotNull Throwable t) {
                log.warn("Failed to connect, retrying in {} seconds.", (Object)timeUnit.convert(delay, TimeUnit.SECONDS));
                log.debug("Specific reason for connection failure follows", t);
                RetryingRequestDispatcher.this.handleFailure((SettableFuture<Response>)future, (Supplier<ListenableFuture<Response>>)code, deadline, delay, timeUnit, t);
            }
        });
    }

    private void handleFailure(final SettableFuture<Response> future, final Supplier<ListenableFuture<Response>> code, final long deadline, final long delay, final TimeUnit timeUnit, Throwable t) {
        if (this.clock.now().getMillis() < deadline) {
            if (delay > 0L) {
                this.executorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        RetryingRequestDispatcher.this.startRetry((SettableFuture<Response>)future, (Supplier<ListenableFuture<Response>>)code, deadline - 1L, delay, timeUnit);
                    }
                }, delay, timeUnit);
            } else {
                this.startRetry(future, code, deadline - 1L, delay, timeUnit);
            }
        } else {
            future.setException(t);
        }
    }
}

