/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.Descriptor;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeploymentGroupStatus
extends Descriptor {
    private final State state;
    private final String error;

    private DeploymentGroupStatus(@JsonProperty(value="state") State state, @JsonProperty(value="error") String error) {
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        this.error = error;
    }

    public Builder toBuilder() {
        return DeploymentGroupStatus.newBuilder().setState(this.state).setError(this.error);
    }

    private DeploymentGroupStatus(Builder builder) {
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)builder.state), (Object)"state"));
        this.error = builder.error;
    }

    public State getState() {
        return this.state;
    }

    public String getError() {
        return this.error;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroupStatus that = (DeploymentGroupStatus)o;
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = this.state != null ? this.state.hashCode() : 0;
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("error", (Object)this.error).toString();
    }

    public static class Builder {
        private State state;
        private String error;

        public Builder setState(State state) {
            this.state = state;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public DeploymentGroupStatus build() {
            return new DeploymentGroupStatus(this);
        }
    }

    public static enum State {
        ROLLING_OUT,
        FAILED,
        DONE;

    }
}

