/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.Job;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
extends Descriptor {
    public static final String EMPTY_DEPLOYER_USER = null;
    public static final String EMPTY_DEPLOYER_MASTER = null;
    public static final String EMPTY_DEPOYMENT_GROUP_NAME = null;
    private final Job job;
    private final Goal goal;
    private final String deployerUser;
    private final String deployerMaster;
    private final String deploymentGroupName;

    public Task(@JsonProperty(value="job") Job job, @JsonProperty(value="goal") Goal goal, @JsonProperty(value="deployerUser") @Nullable String deployerUser, @JsonProperty(value="deployerMaster") @Nullable String deployerMaster, @JsonProperty(value="deploymentGroupName") @Nullable String deploymentGroupName) {
        this.job = (Job)Preconditions.checkNotNull((Object)job, (Object)"job");
        this.goal = (Goal)((Object)Preconditions.checkNotNull((Object)((Object)goal), (Object)"goal"));
        this.deployerUser = deployerUser;
        this.deployerMaster = deployerMaster;
        this.deploymentGroupName = deploymentGroupName;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public Job getJob() {
        return this.job;
    }

    public String getDeployerUser() {
        return this.deployerUser;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String getDeployerMaster() {
        return this.deployerMaster;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        if (this.job != null ? !this.job.equals(task.job) : task.job != null) {
            return false;
        }
        if (this.goal != task.goal) {
            return false;
        }
        if (this.deployerUser != null ? !this.deployerUser.equals(task.deployerUser) : task.deployerUser != null) {
            return false;
        }
        if (this.deploymentGroupName != null ? !this.deploymentGroupName.equals(task.deploymentGroupName) : task.deploymentGroupName != null) {
            return false;
        }
        return !(this.deployerMaster == null ? task.deployerMaster != null : !this.deployerMaster.equals(task.deployerMaster));
    }

    public int hashCode() {
        int result = this.job != null ? this.job.hashCode() : 0;
        result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
        result = 31 * result + (this.deployerUser != null ? this.deployerUser.hashCode() : 0);
        result = 31 * result + (this.deploymentGroupName != null ? this.deploymentGroupName.hashCode() : 0);
        result = 31 * result + (this.deployerMaster != null ? this.deployerMaster.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("job", (Object)this.job).add("goal", (Object)this.goal).add("deployerUser", (Object)this.deployerUser).add("deployerMaster", (Object)this.deployerMaster).add("deploymentGroupName", (Object)this.deploymentGroupName).toString();
    }
}

