/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.tls;

import com.eaio.uuid.UUID;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.spotify.helios.client.tls.SshAgentContentSigner;
import com.spotify.sshagentproxy.AgentProxy;
import com.spotify.sshagentproxy.Identity;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateFactory {
    private static final Logger log = LoggerFactory.getLogger(X509CertificateFactory.class);
    private static final JcaX509CertificateConverter CERTIFICATE_CONVERTER = new JcaX509CertificateConverter().setProvider("BC");
    private static final BaseEncoding KEY_ID_ENCODING = BaseEncoding.base16().upperCase().withSeparator(":", 2);
    private static final BaseEncoding CERT_ENCODING = BaseEncoding.base64().withSeparator("\n", 64);
    private static final int KEY_SIZE = 2048;
    private static final int HOURS_BEFORE = 1;
    private static final int HOURS_AFTER = 48;

    public static CertificateAndKeyPair get(AgentProxy agentProxy, Identity identity, String username) {
        UUID uuid = new UUID();
        Calendar calendar = Calendar.getInstance();
        X500Name issuerDN = new X500Name("C=US,O=Spotify,CN=helios-client");
        X500Name subjectDN = new X500NameBuilder().addRDN(BCStyle.UID, username).build();
        calendar.add(10, -1);
        Date notBefore = calendar.getTime();
        calendar.add(10, 49);
        Date notAfter = calendar.getTime();
        BigInteger serialNumber = BigInteger.valueOf(uuid.getTime()).abs();
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)keyPair.getPublic().getEncoded()));
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerDN, serialNumber, notBefore, notAfter, subjectDN, subjectPublicKeyInfo);
            DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
            X509ExtensionUtils utils = new X509ExtensionUtils(digestCalculator);
            SubjectKeyIdentifier keyId = utils.createSubjectKeyIdentifier(subjectPublicKeyInfo);
            String keyIdHex = KEY_ID_ENCODING.encode(keyId.getKeyIdentifier());
            log.info("generating an X509 certificate with key ID {}", (Object)keyIdHex);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)keyId);
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)utils.createAuthorityKeyIdentifier(subjectPublicKeyInfo));
            builder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(132));
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            X509CertificateHolder holder = builder.build((ContentSigner)new SshAgentContentSigner(agentProxy, identity));
            log.debug("generated certificate:\n{}\n{}\n{}", new Object[]{"-----BEGIN CERTIFICATE-----", CERT_ENCODING.encode(holder.getEncoded()), "-----END CERTIFICATE-----"});
            return new CertificateAndKeyPair(CERTIFICATE_CONVERTER.getCertificate(holder), keyPair);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class CertificateAndKeyPair {
        private final Certificate certificate;
        private final KeyPair keyPair;

        public CertificateAndKeyPair(Certificate certificate, KeyPair keyPair) {
            this.certificate = certificate;
            this.keyPair = keyPair;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }
    }
}

