/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.RolloutTask;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeploymentGroupTasks
extends Descriptor {
    private final List<RolloutTask> rolloutTasks;
    private final int taskIndex;
    private final DeploymentGroup deploymentGroup;

    private DeploymentGroupTasks(@JsonProperty(value="rolloutTasks") List<RolloutTask> rolloutTasks, @JsonProperty(value="taskIndex") int taskIndex, @JsonProperty(value="deploymentGroup") DeploymentGroup deploymentGroup) {
        this.rolloutTasks = (List)Preconditions.checkNotNull(rolloutTasks, (Object)"rolloutTasks");
        this.taskIndex = taskIndex;
        this.deploymentGroup = deploymentGroup;
    }

    public Builder toBuilder() {
        return DeploymentGroupTasks.newBuilder().setRolloutTasks(this.rolloutTasks).setTaskIndex(this.taskIndex).setDeploymentGroup(this.deploymentGroup);
    }

    private DeploymentGroupTasks(Builder builder) {
        this.rolloutTasks = (List)Preconditions.checkNotNull((Object)builder.rolloutTasks, (Object)"rolloutTasks");
        this.taskIndex = builder.taskIndex;
        this.deploymentGroup = (DeploymentGroup)Preconditions.checkNotNull((Object)builder.deploymentGroup, (Object)"deploymentGroup");
    }

    public List<RolloutTask> getRolloutTasks() {
        return this.rolloutTasks;
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public DeploymentGroup getDeploymentGroup() {
        return this.deploymentGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroupTasks that = (DeploymentGroupTasks)o;
        if (this.taskIndex != that.taskIndex) {
            return false;
        }
        if (this.deploymentGroup != null ? !this.deploymentGroup.equals(that.deploymentGroup) : that.deploymentGroup != null) {
            return false;
        }
        return !(this.rolloutTasks != null ? !this.rolloutTasks.equals(that.rolloutTasks) : that.rolloutTasks != null);
    }

    public int hashCode() {
        int result = this.rolloutTasks != null ? this.rolloutTasks.hashCode() : 0;
        result = 31 * result + this.taskIndex;
        result = 31 * result + (this.deploymentGroup != null ? this.deploymentGroup.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rolloutTasks", this.rolloutTasks).add("taskIndex", this.taskIndex).add("deploymentGroup", (Object)this.deploymentGroup).toString();
    }

    public static class Builder {
        private List<RolloutTask> rolloutTasks = Collections.emptyList();
        private int taskIndex;
        private DeploymentGroup deploymentGroup;

        public Builder setRolloutTasks(List<RolloutTask> rolloutTasks) {
            this.rolloutTasks = rolloutTasks;
            return this;
        }

        public Builder setTaskIndex(int taskIndex) {
            this.taskIndex = taskIndex;
            return this;
        }

        public Builder setDeploymentGroup(DeploymentGroup deploymentGroup) {
            this.deploymentGroup = deploymentGroup;
            return this;
        }

        public DeploymentGroupTasks build() {
            return new DeploymentGroupTasks(this);
        }
    }
}

