/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.DockerVersion;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostInfo
extends Descriptor {
    private final String hostname;
    private final String uname;
    private final String architecture;
    private final String osName;
    private final String osVersion;
    private final int cpus;
    private final double loadAvg;
    private final long memoryTotalBytes;
    private final long memoryFreeBytes;
    private final long swapTotalBytes;
    private final long swapFreeBytes;
    private final DockerVersion dockerVersion;
    private final String dockerHost;
    private final String dockerCertPath;

    public HostInfo(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="uname") String uname, @JsonProperty(value="architecture") String architecture, @JsonProperty(value="osName") String osName, @JsonProperty(value="osVersion") String osVersion, @JsonProperty(value="cpus") int cpus, @JsonProperty(value="loadAvg") double loadAvg, @JsonProperty(value="memoryTotalBytes") long memoryTotalBytes, @JsonProperty(value="memoryFreeBytes") long memoryFreeBytes, @JsonProperty(value="swapTotalBytes") long swapTotalBytes, @JsonProperty(value="swapFreeBytes") long swapFreeBytes, @JsonProperty(value="dockerVersion") DockerVersion dockerVersion, @JsonProperty(value="dockerHost") String dockerHost, @JsonProperty(value="dockerCertPath") String dockerCertPath) {
        this.hostname = hostname;
        this.uname = uname;
        this.architecture = architecture;
        this.osName = osName;
        this.osVersion = osVersion;
        this.cpus = cpus;
        this.loadAvg = loadAvg;
        this.memoryTotalBytes = memoryTotalBytes;
        this.memoryFreeBytes = memoryFreeBytes;
        this.swapTotalBytes = swapTotalBytes;
        this.swapFreeBytes = swapFreeBytes;
        this.dockerVersion = dockerVersion;
        this.dockerHost = dockerHost;
        this.dockerCertPath = dockerCertPath;
    }

    public HostInfo(Builder builder) {
        this.hostname = builder.hostname;
        this.uname = builder.uname;
        this.architecture = builder.architecture;
        this.osName = builder.osName;
        this.osVersion = builder.osVersion;
        this.cpus = builder.cpus;
        this.loadAvg = builder.loadAvg;
        this.memoryTotalBytes = builder.memoryTotalBytes;
        this.memoryFreeBytes = builder.memoryFreeBytes;
        this.swapTotalBytes = builder.swapTotalBytes;
        this.swapFreeBytes = builder.swapFreeBytes;
        this.dockerVersion = builder.dockerVersion;
        this.dockerHost = builder.dockerHost;
        this.dockerCertPath = builder.dockerCertPath;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUname() {
        return this.uname;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public int getCpus() {
        return this.cpus;
    }

    public double getLoadAvg() {
        return this.loadAvg;
    }

    public long getMemoryTotalBytes() {
        return this.memoryTotalBytes;
    }

    public long getMemoryFreeBytes() {
        return this.memoryFreeBytes;
    }

    public long getSwapTotalBytes() {
        return this.swapTotalBytes;
    }

    public long getSwapFreeBytes() {
        return this.swapFreeBytes;
    }

    public DockerVersion getDockerVersion() {
        return this.dockerVersion;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostname", (Object)this.hostname).add("uname", (Object)this.uname).add("architecture", (Object)this.architecture).add("osName", (Object)this.osName).add("osVersion", (Object)this.osVersion).add("cpus", this.cpus).add("loadAvg", this.loadAvg).add("memoryTotalBytes", this.memoryTotalBytes).add("memoryFreeBytes", this.memoryFreeBytes).add("swapTotalBytes", this.swapTotalBytes).add("swapFreeBytes", this.swapFreeBytes).add("dockerVersion", (Object)this.dockerVersion).add("dockerHost", (Object)this.dockerHost).add("dockerCertPath", (Object)this.dockerCertPath).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostInfo hostInfo = (HostInfo)o;
        if (this.cpus != hostInfo.cpus) {
            return false;
        }
        if (Double.compare(hostInfo.loadAvg, this.loadAvg) != 0) {
            return false;
        }
        if (this.memoryTotalBytes != hostInfo.memoryTotalBytes) {
            return false;
        }
        if (this.memoryFreeBytes != hostInfo.memoryFreeBytes) {
            return false;
        }
        if (this.swapTotalBytes != hostInfo.swapTotalBytes) {
            return false;
        }
        if (this.swapFreeBytes != hostInfo.swapFreeBytes) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(hostInfo.hostname) : hostInfo.hostname != null) {
            return false;
        }
        if (this.uname != null ? !this.uname.equals(hostInfo.uname) : hostInfo.uname != null) {
            return false;
        }
        if (this.architecture != null ? !this.architecture.equals(hostInfo.architecture) : hostInfo.architecture != null) {
            return false;
        }
        if (this.osName != null ? !this.osName.equals(hostInfo.osName) : hostInfo.osName != null) {
            return false;
        }
        if (this.osVersion != null ? !this.osVersion.equals(hostInfo.osVersion) : hostInfo.osVersion != null) {
            return false;
        }
        if (this.dockerVersion != null ? !this.dockerVersion.equals(hostInfo.dockerVersion) : hostInfo.dockerVersion != null) {
            return false;
        }
        if (this.dockerHost != null ? !this.dockerHost.equals(hostInfo.dockerHost) : hostInfo.dockerHost != null) {
            return false;
        }
        return !(this.dockerCertPath == null ? hostInfo.dockerCertPath != null : !this.dockerCertPath.equals(hostInfo.dockerCertPath));
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.uname != null ? this.uname.hashCode() : 0);
        result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
        result = 31 * result + (this.osName != null ? this.osName.hashCode() : 0);
        result = 31 * result + (this.osVersion != null ? this.osVersion.hashCode() : 0);
        result = 31 * result + this.cpus;
        long temp = Double.doubleToLongBits(this.loadAvg);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.memoryTotalBytes ^ this.memoryTotalBytes >>> 32);
        result = 31 * result + (int)(this.memoryFreeBytes ^ this.memoryFreeBytes >>> 32);
        result = 31 * result + (int)(this.swapTotalBytes ^ this.swapTotalBytes >>> 32);
        result = 31 * result + (int)(this.swapFreeBytes ^ this.swapFreeBytes >>> 32);
        result = 31 * result + (this.dockerVersion != null ? this.dockerVersion.hashCode() : 0);
        result = 31 * result + (this.dockerHost != null ? this.dockerHost.hashCode() : 0);
        result = 31 * result + (this.dockerCertPath != null ? this.dockerCertPath.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String hostname;
        private String uname;
        private String architecture;
        private String osName;
        private String osVersion;
        private int cpus;
        private double loadAvg;
        private long memoryTotalBytes;
        private long memoryFreeBytes;
        private long swapTotalBytes;
        private long swapFreeBytes;
        private DockerVersion dockerVersion;
        private String dockerHost;
        private String dockerCertPath;

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setUname(String uname) {
            this.uname = uname;
            return this;
        }

        public Builder setArchitecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder setOsName(String osName) {
            this.osName = osName;
            return this;
        }

        public Builder setOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder setCpus(int cpus) {
            this.cpus = cpus;
            return this;
        }

        public Builder setLoadAvg(double loadAvg) {
            this.loadAvg = loadAvg;
            return this;
        }

        public Builder setMemoryTotalBytes(long memoryTotalBytes) {
            this.memoryTotalBytes = memoryTotalBytes;
            return this;
        }

        public Builder setMemoryFreeBytes(long memoryFreeBytes) {
            this.memoryFreeBytes = memoryFreeBytes;
            return this;
        }

        public Builder setSwapTotalBytes(long swapTotalBytes) {
            this.swapTotalBytes = swapTotalBytes;
            return this;
        }

        public Builder setSwapFreeBytes(long swapFreeBytes) {
            this.swapFreeBytes = swapFreeBytes;
            return this;
        }

        public Builder setDockerVersion(DockerVersion dockerVersion) {
            this.dockerVersion = dockerVersion;
            return this;
        }

        public Builder setDockerHost(String dockerHost) {
            this.dockerHost = dockerHost;
            return this;
        }

        public Builder setDockerCertPath(String dockerCertPath) {
            this.dockerCertPath = dockerCertPath;
            return this;
        }

        public HostInfo build() {
            return new HostInfo(this);
        }
    }
}

