/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.spotify.helios.common.descriptors.Descriptor;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PortMapping
extends Descriptor {
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    private final int internalPort;
    private final Integer externalPort;
    private final String protocol;

    public PortMapping(@JsonProperty(value="internalPort") int internalPort, @JsonProperty(value="externalPort") Integer externalPort, @JsonProperty(value="protocol") String protocol) {
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.protocol = (String)Optional.fromNullable((Object)protocol).or((Object)TCP);
    }

    public PortMapping(int internalPort, Integer externalPort) {
        this.internalPort = internalPort;
        this.externalPort = externalPort;
        this.protocol = TCP;
    }

    public PortMapping(int internalPort) {
        this.internalPort = internalPort;
        this.externalPort = null;
        this.protocol = TCP;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public boolean hasExternalPort() {
        return this.externalPort != null;
    }

    @Nullable
    public Integer getExternalPort() {
        return this.externalPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public PortMapping withExternalPort(Integer externalPort) {
        return PortMapping.of(this.internalPort, externalPort, this.protocol);
    }

    public static PortMapping of(int internalPort) {
        return new PortMapping(internalPort);
    }

    public static PortMapping of(int internalPort, Integer externalPort) {
        return new PortMapping(internalPort, externalPort);
    }

    public static PortMapping of(int internalPort, Integer externalPort, String protocol) {
        return new PortMapping(internalPort, externalPort, protocol);
    }

    public static PortMapping of(int internalPort, String protocol) {
        return new PortMapping(internalPort, null, protocol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortMapping that = (PortMapping)o;
        if (this.internalPort != that.internalPort) {
            return false;
        }
        if (this.externalPort != null ? !this.externalPort.equals(that.externalPort) : that.externalPort != null) {
            return false;
        }
        return !(this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null);
    }

    public int hashCode() {
        int result = this.internalPort;
        result = 31 * result + (this.externalPort != null ? this.externalPort.hashCode() : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("internalPort", this.internalPort).add("externalPort", (Object)this.externalPort).add("protocol", (Object)this.protocol).toString();
    }
}

