/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.com.spotify.dns;

import com.google.common.base.Preconditions;
import com.spotify.helios.client.shaded.com.spotify.dns.ChangeNotifier;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractChangeNotifier<T>
implements ChangeNotifier<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractChangeNotifier.class);
    private final AtomicReference<ChangeNotifier.Listener<T>> listenerRef = new AtomicReference();

    AbstractChangeNotifier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(ChangeNotifier.Listener<T> listener, boolean fire) {
        Preconditions.checkNotNull(listener, (Object)"listener");
        AbstractChangeNotifier abstractChangeNotifier = this;
        synchronized (abstractChangeNotifier) {
            if (!this.listenerRef.compareAndSet(null, listener)) {
                throw new IllegalStateException("Listener already set!");
            }
            if (fire) {
                this.fireRecordsUpdated(this.newChangeNotification(this.current(), Collections.emptySet()));
            }
        }
    }

    @Override
    public final void close() {
        this.listenerRef.set(null);
        this.closeImplementation();
    }

    protected abstract void closeImplementation();

    protected final void fireRecordsUpdated(ChangeNotifier.ChangeNotification<T> changeNotification) {
        Preconditions.checkNotNull(changeNotification, (Object)"changeNotification");
        ChangeNotifier.Listener<T> listener = this.listenerRef.get();
        if (listener != null) {
            try {
                listener.onChange(changeNotification);
            }
            catch (Throwable e) {
                log.error("Change notification lister threw exception", e);
            }
        }
    }

    protected final ChangeNotifier.ChangeNotification<T> newChangeNotification(Set<T> current, Set<T> previous) {
        Preconditions.checkNotNull(current, (Object)"current");
        Preconditions.checkNotNull(previous, (Object)"previous");
        return new ChangeNotificationImpl<T>(current, previous);
    }

    private static class ChangeNotificationImpl<T>
    implements ChangeNotifier.ChangeNotification<T> {
        private final Set<T> current;
        private final Set<T> previous;

        protected ChangeNotificationImpl(Set<T> current, Set<T> previous) {
            this.current = current;
            this.previous = previous;
        }

        @Override
        public Set<T> current() {
            return Collections.unmodifiableSet(this.current);
        }

        @Override
        public Set<T> previous() {
            return Collections.unmodifiableSet(this.previous);
        }
    }
}

