/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.org.xbill.DNS;

import com.spotify.helios.client.shaded.org.xbill.DNS.DClass;
import com.spotify.helios.client.shaded.org.xbill.DNS.Message;
import com.spotify.helios.client.shaded.org.xbill.DNS.Name;
import com.spotify.helios.client.shaded.org.xbill.DNS.RRset;
import com.spotify.helios.client.shaded.org.xbill.DNS.Record;
import com.spotify.helios.client.shaded.org.xbill.DNS.RelativeNameException;
import com.spotify.helios.client.shaded.org.xbill.DNS.Tokenizer;
import java.io.IOException;
import java.util.Iterator;

public class Update
extends Message {
    private Name origin;
    private int dclass;

    public Update(Name zone, int dclass) {
        if (!zone.isAbsolute()) {
            throw new RelativeNameException(zone);
        }
        DClass.check(dclass);
        this.getHeader().setOpcode(5);
        Record soa = Record.newRecord(zone, 6, 1);
        this.addRecord(soa, 0);
        this.origin = zone;
        this.dclass = dclass;
    }

    public Update(Name zone) {
        this(zone, 1);
    }

    private void newPrereq(Record rec) {
        this.addRecord(rec, 1);
    }

    private void newUpdate(Record rec) {
        this.addRecord(rec, 2);
    }

    public void present(Name name) {
        this.newPrereq(Record.newRecord(name, 255, 255, 0L));
    }

    public void present(Name name, int type) {
        this.newPrereq(Record.newRecord(name, type, 255, 0L));
    }

    public void present(Name name, int type, String record) throws IOException {
        this.newPrereq(Record.fromString(name, type, this.dclass, 0L, record, this.origin));
    }

    public void present(Name name, int type, Tokenizer tokenizer) throws IOException {
        this.newPrereq(Record.fromString(name, type, this.dclass, 0L, tokenizer, this.origin));
    }

    public void present(Record record) {
        this.newPrereq(record);
    }

    public void absent(Name name) {
        this.newPrereq(Record.newRecord(name, 255, 254, 0L));
    }

    public void absent(Name name, int type) {
        this.newPrereq(Record.newRecord(name, type, 254, 0L));
    }

    public void add(Name name, int type, long ttl, String record) throws IOException {
        this.newUpdate(Record.fromString(name, type, this.dclass, ttl, record, this.origin));
    }

    public void add(Name name, int type, long ttl, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString(name, type, this.dclass, ttl, tokenizer, this.origin));
    }

    public void add(Record record) {
        this.newUpdate(record);
    }

    public void add(Record[] records) {
        for (int i = 0; i < records.length; ++i) {
            this.add(records[i]);
        }
    }

    public void add(RRset rrset) {
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.add((Record)it.next());
        }
    }

    public void delete(Name name) {
        this.newUpdate(Record.newRecord(name, 255, 255, 0L));
    }

    public void delete(Name name, int type) {
        this.newUpdate(Record.newRecord(name, type, 255, 0L));
    }

    public void delete(Name name, int type, String record) throws IOException {
        this.newUpdate(Record.fromString(name, type, 254, 0L, record, this.origin));
    }

    public void delete(Name name, int type, Tokenizer tokenizer) throws IOException {
        this.newUpdate(Record.fromString(name, type, 254, 0L, tokenizer, this.origin));
    }

    public void delete(Record record) {
        this.newUpdate(record.withDClass(254, 0L));
    }

    public void delete(Record[] records) {
        for (int i = 0; i < records.length; ++i) {
            this.delete(records[i]);
        }
    }

    public void delete(RRset rrset) {
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.delete((Record)it.next());
        }
    }

    public void replace(Name name, int type, long ttl, String record) throws IOException {
        this.delete(name, type);
        this.add(name, type, ttl, record);
    }

    public void replace(Name name, int type, long ttl, Tokenizer tokenizer) throws IOException {
        this.delete(name, type);
        this.add(name, type, ttl, tokenizer);
    }

    public void replace(Record record) {
        this.delete(record.getName(), record.getType());
        this.add(record);
    }

    public void replace(Record[] records) {
        for (int i = 0; i < records.length; ++i) {
            this.replace(records[i]);
        }
    }

    public void replace(RRset rrset) {
        this.delete(rrset.getName(), rrset.getType());
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            this.add((Record)it.next());
        }
    }
}

