/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.spotify.helios.client.RequestDispatcher;
import com.spotify.helios.client.Response;
import com.spotify.helios.common.Clock;
import com.spotify.helios.common.SystemClock;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryingRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RetryingRequestDispatcher.class);
    private final ListeningScheduledExecutorService executorService;
    private final RequestDispatcher delegate;
    private final Clock clock;
    private final long retryTimeoutMillis;
    private final long delayMillis;

    private RetryingRequestDispatcher(RequestDispatcher delegate, ListeningScheduledExecutorService executorService, Clock clock, long retryTimeoutMillis, long delayMillis) {
        this.delegate = delegate;
        this.executorService = executorService;
        this.clock = clock;
        this.retryTimeoutMillis = retryTimeoutMillis;
        this.delayMillis = delayMillis;
    }

    @Override
    public ListenableFuture<Response> request(final URI uri, final String method, final byte[] entityBytes, final Map<String, List<String>> headers) {
        long deadline = this.clock.now().getMillis() + this.retryTimeoutMillis;
        SettableFuture future = SettableFuture.create();
        Supplier<ListenableFuture<Response>> code = new Supplier<ListenableFuture<Response>>(){

            public ListenableFuture<Response> get() {
                return RetryingRequestDispatcher.this.delegate.request(uri, method, entityBytes, headers);
            }
        };
        this.startRetry((SettableFuture<Response>)future, code, deadline, this.delayMillis, uri);
        return future;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void startRetry(final SettableFuture<Response> future, final Supplier<ListenableFuture<Response>> code, final long deadline, final long delayMillis, final URI uri) {
        ListenableFuture codeFuture;
        try {
            codeFuture = (ListenableFuture)code.get();
        }
        catch (Exception e) {
            log.debug("Failed to connect to {}, retrying in {} seconds.", (Object)uri.toString(), (Object)TimeUnit.MILLISECONDS.toSeconds(delayMillis));
            log.debug("Specific reason for connection failure follows", (Throwable)e);
            this.handleFailure(future, code, deadline, delayMillis, e, uri);
            return;
        }
        Futures.addCallback((ListenableFuture)codeFuture, (FutureCallback)new FutureCallback<Response>(){

            public void onSuccess(Response result) {
                future.set((Object)result);
            }

            public void onFailure(@NotNull Throwable t) {
                log.warn("Failed to connect to {}, retrying in {} seconds.", (Object)uri.toString(), (Object)TimeUnit.MILLISECONDS.toSeconds(delayMillis));
                log.debug("Specific reason for connection failure follows", t);
                RetryingRequestDispatcher.this.handleFailure((SettableFuture<Response>)future, (Supplier<ListenableFuture<Response>>)code, deadline, delayMillis, t, uri);
            }
        });
    }

    private void handleFailure(final SettableFuture<Response> future, final Supplier<ListenableFuture<Response>> code, final long deadline, final long delayMillis, Throwable t, final URI uri) {
        if (this.clock.now().getMillis() < deadline) {
            if (delayMillis > 0L) {
                this.executorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        RetryingRequestDispatcher.this.startRetry((SettableFuture<Response>)future, (Supplier<ListenableFuture<Response>>)code, deadline - 1L, delayMillis, uri);
                    }
                }, delayMillis, TimeUnit.MILLISECONDS);
            } else {
                this.startRetry(future, code, deadline - 1L, delayMillis, uri);
            }
        } else {
            future.setException(t);
        }
    }

    static Builder forDispatcher(RequestDispatcher delegate) {
        return new Builder(delegate);
    }

    public static final class Builder {
        private final RequestDispatcher delegate;
        private ListeningScheduledExecutorService executor;
        private Clock clock = new SystemClock();
        private long retryTimeoutMillis = 60000L;
        private long delayMillis = 5000L;

        private Builder(RequestDispatcher delegate) {
            this.delegate = delegate;
        }

        public Builder setExecutor(ScheduledExecutorService executorService) {
            this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorService);
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setRetryTimeout(long timeout, TimeUnit unit) {
            this.retryTimeoutMillis = unit.toMillis(timeout);
            return this;
        }

        public Builder setDelayOnFailure(long delay, TimeUnit unit) {
            this.delayMillis = unit.toMillis(delay);
            return this;
        }

        public RetryingRequestDispatcher build() {
            return new RetryingRequestDispatcher(this.delegate, this.executor, this.clock, this.retryTimeoutMillis, this.delayMillis);
        }
    }
}

