/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.spotify.helios.common.descriptors.Descriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostSelector
extends Descriptor {
    private static BiPredicate<String, Object> IN_BIPREDICATE = new BiPredicate<String, Object>(){

        @Override
        public boolean test(String a, Object b) {
            Iterable iterable = (Iterable)b;
            return Iterables.contains((Iterable)iterable, (Object)a);
        }
    };
    private static final String LABEL_PATTERN = "[\\p{Alnum}\\._-]+";
    private static final String OPERAND_PATTERN = "[\\p{Alnum}\\._-]+|\\([\\p{Alnum}\\.\\s,_-]*\\)";
    private static final Pattern PATTERN = Pattern.compile(String.format("^(%s)\\s*(!=|=|in|notin)\\s*(%s)$", "[\\p{Alnum}\\._-]+", "[\\p{Alnum}\\._-]+|\\([\\p{Alnum}\\.\\s,_-]*\\)"));
    private final String label;
    private final Operator operator;
    private final Object operand;

    public static HostSelector parse(String str) {
        Preconditions.checkNotNull((Object)str);
        Matcher matcher = PATTERN.matcher(str);
        if (matcher.matches()) {
            String label = matcher.group(1);
            String opStr = matcher.group(2);
            String value = matcher.group(3);
            Operator operator = null;
            for (Operator op : Operator.values()) {
                if (!op.operatorName.equals(opStr)) continue;
                operator = op;
            }
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Unknown operator '%s'", opStr));
            }
            if (operator == Operator.IN || operator == Operator.NOT_IN) {
                ArrayList parts = Lists.newArrayList((Iterable)Sets.newHashSet(Arrays.asList(value.replaceAll("\\(|\\)| ", "").split(","))));
                return new HostSelector(label, operator, parts);
            }
            return new HostSelector(label, operator, value);
        }
        return null;
    }

    public HostSelector(@JsonProperty(value="label") String label, @JsonProperty(value="operator") Operator operator, @JsonProperty(value="operand") Object operand) {
        this.label = label;
        this.operator = operator;
        this.operand = operand;
    }

    public String getLabel() {
        return this.label;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getOperand() {
        return this.operand;
    }

    public boolean matches(@Nullable String value) {
        return this.operator.predicate.test(value, this.operand);
    }

    public String toPrettyString() {
        return String.format("%s %s %s", this.label, this.operator.operatorName, this.operand.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostSelector that = (HostSelector)o;
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.operand != null ? !this.operand.equals(that.operand) : that.operand != null) {
            return false;
        }
        return this.operator == that.operator;
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.operand != null ? this.operand.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HostSelector{label='" + this.label + '\'' + ", operator=" + (Object)((Object)this.operator) + ", operand=" + this.operand + '}';
    }

    public static enum Operator {
        EQUALS("=", new BiPredicate<String, Object>(){

            @Override
            public boolean test(String a, Object b) {
                return Objects.equals(a, b);
            }
        }),
        NOT_EQUALS("!=", new BiPredicate<String, Object>(){

            @Override
            public boolean test(String a, Object b) {
                return !Objects.equals(a, b);
            }
        }),
        IN("in", HostSelector.access$000()),
        NOT_IN("notin", new BiPredicate<String, Object>(){

            @Override
            public boolean test(String a, Object b) {
                return !IN_BIPREDICATE.test(a, b);
            }
        });

        final String operatorName;
        final BiPredicate<String, Object> predicate;

        private Operator(String operatorName, BiPredicate<String, Object> predicate) {
            this.operatorName = operatorName;
            this.predicate = predicate;
        }
    }

    private static interface BiPredicate<T, U> {
        public boolean test(T var1, U var2);
    }
}

