/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.JobIdParseException;
import java.util.Comparator;

@JsonSerialize
@JsonIgnoreProperties(ignoreUnknown=true)
public class JobId
extends Descriptor
implements Comparable<JobId> {
    private final String name;
    private final String version;
    private final String hash;
    public static final Function<String, JobId> FROM_STRING = new Function<String, JobId>(){

        public JobId apply(String s) {
            return JobId.fromString(s);
        }
    };

    public JobId(String name, String version, String hash) {
        this.name = name;
        this.version = version;
        this.hash = hash;
    }

    public JobId(String name, String version) {
        this.name = name;
        this.version = version;
        this.hash = null;
    }

    @JsonCreator
    private JobId(String id) {
        String[] parts = id.split(":");
        if (parts.length != 2 && parts.length != 3) {
            throw new IllegalArgumentException("Invalid Job id: " + id);
        }
        this.name = parts[0];
        this.version = parts[1];
        this.hash = parts.length == 3 ? parts[2] : null;
    }

    private JobId(String name, boolean b) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)name, (Object)"name is null")).isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        this.name = name;
        this.version = null;
        this.hash = null;
    }

    public static JobId fromString(String id) {
        try {
            return JobId.parse(id);
        }
        catch (JobIdParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JobId parse(String id) throws JobIdParseException {
        String[] parts = id.split(":");
        switch (parts.length) {
            case 1: {
                return new JobId(parts[0], true);
            }
            case 2: {
                return new JobId(parts[0], parts[1]);
            }
            case 3: {
                return new JobId(parts[0], parts[1], parts[2]);
            }
        }
        throw new JobIdParseException("Invalid Job id: " + id);
    }

    @JsonValue
    public String toString() {
        if (this.hash == null) {
            return this.name + ":" + this.version;
        }
        return this.name + ":" + this.version + ":" + this.hash;
    }

    public String toShortString() {
        if (this.hash == null) {
            return this.name + ":" + this.version;
        }
        return this.name + ":" + this.version + ":" + this.hash.substring(0, 7);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobId jobId = (JobId)o;
        if (this.hash != null ? !this.hash.equals(jobId.hash) : jobId.hash != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(jobId.name) : jobId.name != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(jobId.version) : jobId.version != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(JobId o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)o.name)).compare((Comparable)((Object)this.version), (Comparable)((Object)o.version)).compare((Object)this.hash, (Object)o.hash, (Comparator)Ordering.natural().nullsFirst()).result();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isFullyQualified() {
        return this.name != null && this.version != null && this.hash != null && this.hash.length() == 40;
    }

    public static class Builder {
        private String name;
        private String version;
        private String hash;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setHash(String hash) {
            this.hash = hash;
            return this;
        }

        public JobId build() {
            if (this.hash == null) {
                return new JobId(this.name, this.version);
            }
            return new JobId(this.name, this.version, this.hash);
        }
    }
}

