/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.spotify.helios.client.ClientCertificatePath;
import com.spotify.helios.client.HttpsHandler;
import com.spotify.helios.client.tls.CertificateAndPrivateKey;
import com.spotify.helios.client.tls.X509CertificateFactory;
import com.spotify.sshagentproxy.AgentProxy;
import com.spotify.sshagentproxy.Identity;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpsHandlers {
    HttpsHandlers() {
    }

    protected static abstract class CertificateHttpsHandler
    implements HttpsHandler {
        private static final Logger log = LoggerFactory.getLogger(CertificateHttpsHandler.class);
        private static final char[] KEY_STORE_PASSWORD = "FPLSlZQuM3ZCM3SjINSKuWyPK2HeS4".toCharArray();
        private final String user;
        private final boolean failOnCertificateError;

        protected CertificateHttpsHandler(String user, boolean failOnCertificateError) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0);
            this.user = user;
            this.failOnCertificateError = failOnCertificateError;
        }

        protected String getUser() {
            return this.user;
        }

        protected boolean getFailOnCertificateError() {
            return this.failOnCertificateError;
        }

        protected abstract CertificateAndPrivateKey createCertificateAndPrivateKey() throws IOException, GeneralSecurityException;

        protected abstract String getCertificateSource();

        @Override
        public void handle(HttpsURLConnection conn) {
            CertificateAndPrivateKey certificateAndPrivateKey;
            try {
                certificateAndPrivateKey = this.createCertificateAndPrivateKey();
            }
            catch (IOException | GeneralSecurityException e) {
                if (this.failOnCertificateError) {
                    throw Throwables.propagate((Throwable)e);
                }
                log.warn("Error when setting up client certificates from {}. Error was '{}'. No certificate will be sent with request.", (Object)this.getCertificateSource(), (Object)e.toString());
                log.debug("full exception from setting up ClientCertificate follows", (Throwable)e);
                return;
            }
            Certificate certificate = certificateAndPrivateKey.getCertificate();
            PrivateKey privateKey = certificateAndPrivateKey.getPrivateKey();
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                keyStore.setCertificateEntry("client", certificate);
                keyStore.setKeyEntry("key", privateKey, KEY_STORE_PASSWORD, new Certificate[]{certificate});
                SSLContext sslContext = SSLContexts.custom().useProtocol("TLS").loadKeyMaterial(keyStore, KEY_STORE_PASSWORD).build();
                conn.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    static class CertificateFileHttpsHandler
    extends CertificateHttpsHandler {
        private final ClientCertificatePath clientCertificatePath;

        CertificateFileHttpsHandler(String user, boolean failOnCertificateError, ClientCertificatePath clientCertificatePath) {
            super(user, failOnCertificateError);
            this.clientCertificatePath = (ClientCertificatePath)Preconditions.checkNotNull((Object)clientCertificatePath);
        }

        @VisibleForTesting
        protected ClientCertificatePath getClientCertificatePath() {
            return this.clientCertificatePath;
        }

        @Override
        protected CertificateAndPrivateKey createCertificateAndPrivateKey() throws IOException, GeneralSecurityException {
            return CertificateAndPrivateKey.from(this.clientCertificatePath.getCertificatePath(), this.clientCertificatePath.getKeyPath());
        }

        @Override
        protected String getCertificateSource() {
            return this.clientCertificatePath.toString();
        }
    }

    static class SshAgentHttpsHandler
    extends CertificateHttpsHandler {
        private static final Logger log = LoggerFactory.getLogger(SshAgentHttpsHandler.class);
        private final AgentProxy agentProxy;
        private final Identity identity;
        private final X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();

        SshAgentHttpsHandler(String user, boolean failOnCertificateError, AgentProxy agentProxy, Identity identity) {
            super(user, failOnCertificateError);
            this.agentProxy = (AgentProxy)Preconditions.checkNotNull((Object)agentProxy, (Object)"agentProxy");
            this.identity = (Identity)Preconditions.checkNotNull((Object)identity, (Object)"identity");
        }

        @VisibleForTesting
        protected AgentProxy getAgentProxy() {
            return this.agentProxy;
        }

        @VisibleForTesting
        protected Identity getIdentity() {
            return this.identity;
        }

        @Override
        protected CertificateAndPrivateKey createCertificateAndPrivateKey() {
            return this.x509CertificateFactory.get(this.agentProxy, this.identity, this.getUser());
        }

        @Override
        protected String getCertificateSource() {
            return "ssh-agent key: " + this.identity.getComment();
        }
    }
}

