/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RolloutOptions {
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    public static final int DEFAULT_PARALLELISM = 1;
    private final long timeout;
    private final int parallelism;
    private final boolean migrate;
    private final boolean overlap;
    private final String token;

    public RolloutOptions(@JsonProperty(value="timeout") long timeout, @JsonProperty(value="parallelism") int parallelism, @JsonProperty(value="migrate") boolean migrate, @JsonProperty(value="overlap") boolean overlap, @JsonProperty(value="token") @Nullable String token) {
        this.timeout = timeout;
        this.parallelism = parallelism;
        this.migrate = migrate;
        this.overlap = overlap;
        this.token = (String)Optional.fromNullable((Object)token).or((Object)"");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().setTimeout(this.timeout).setParallelism(this.parallelism).setMigrate(this.migrate).setToken(this.token);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getMigrate() {
        return this.migrate;
    }

    public boolean getOverlap() {
        return this.overlap;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloutOptions that = (RolloutOptions)o;
        if (this.migrate != that.migrate) {
            return false;
        }
        if (this.parallelism != that.parallelism) {
            return false;
        }
        if (this.timeout != that.timeout) {
            return false;
        }
        if (this.overlap != that.overlap) {
            return false;
        }
        return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.parallelism;
        result = 31 * result + (this.migrate ? 1 : 0);
        result = 31 * result + (this.overlap ? 1 : 0);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RolloutOptions{timeout=" + this.timeout + ", parallelism=" + this.parallelism + ", migrate=" + this.migrate + ", overlap=" + this.overlap + ", token=" + this.token + '}';
    }

    public static class Builder {
        private long timeout = DEFAULT_TIMEOUT;
        private int parallelism = 1;
        private boolean migrate = false;
        private boolean overlap = false;
        private String token = "";

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder setMigrate(boolean migrate) {
            this.migrate = migrate;
            return this;
        }

        public Builder setOverlap(boolean overlap) {
            this.overlap = overlap;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public RolloutOptions build() {
            return new RolloutOptions(this.timeout, this.parallelism, this.migrate, this.overlap, this.token);
        }
    }
}

