/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.helios.client.AuthenticatingHttpConnector;
import com.spotify.helios.client.ClientCertificatePath;
import com.spotify.helios.client.DefaultHttpConnector;
import com.spotify.helios.client.DefaultRequestDispatcher;
import com.spotify.helios.client.Endpoint;
import com.spotify.helios.client.EndpointIterator;
import com.spotify.helios.client.Endpoints;
import com.spotify.helios.client.HttpConnector;
import com.spotify.helios.client.RequestDispatcher;
import com.spotify.helios.client.Response;
import com.spotify.helios.client.RetryingRequestDispatcher;
import com.spotify.helios.common.HeliosException;
import com.spotify.helios.common.Json;
import com.spotify.helios.common.Resolver;
import com.spotify.helios.common.VersionCompatibility;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.DeploymentGroup;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.RolloutOptions;
import com.spotify.helios.common.protocol.CreateDeploymentGroupResponse;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.DeploymentGroupStatusResponse;
import com.spotify.helios.common.protocol.HostDeregisterResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.common.protocol.RemoveDeploymentGroupResponse;
import com.spotify.helios.common.protocol.RollingUpdateRequest;
import com.spotify.helios.common.protocol.RollingUpdateResponse;
import com.spotify.helios.common.protocol.SetGoalResponse;
import com.spotify.helios.common.protocol.TaskStatusEvents;
import com.spotify.helios.common.protocol.VersionResponse;
import com.spotify.sshagentproxy.AgentProxies;
import com.spotify.sshagentproxy.AgentProxy;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliosClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HeliosClient.class);
    private final String user;
    private final RequestDispatcher dispatcher;
    private final AtomicBoolean versionWarningLogged = new AtomicBoolean();

    public HeliosClient(String user, RequestDispatcher dispatcher) {
        this.user = (String)Preconditions.checkNotNull((Object)user);
        this.dispatcher = (RequestDispatcher)Preconditions.checkNotNull((Object)dispatcher);
    }

    @Override
    public void close() throws IOException {
        this.dispatcher.close();
    }

    private URI uri(String path) {
        return this.uri(path, Collections.emptyMap());
    }

    private URI uri(String path, Map<String, String> query) {
        return this.uri(path, (Multimap<String, String>)Multimaps.forMap(query));
    }

    private URI uri(String path, Multimap<String, String> query) {
        Preconditions.checkArgument((boolean)path.startsWith("/"));
        URIBuilder builder = new URIBuilder().setScheme("http").setHost("helios").setPath(path);
        for (Map.Entry q : query.entries()) {
            builder.addParameter((String)q.getKey(), (String)q.getValue());
        }
        builder.addParameter("user", this.user);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String path(String resource, Object ... params) {
        String path;
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        if (params.length == 0) {
            path = resource;
        } else {
            ArrayList encodedParams = Lists.newArrayList();
            for (Object param : params) {
                encodedParams.add(escaper.escape(param.toString()));
            }
            path = String.format(resource, encodedParams.toArray());
        }
        return path;
    }

    private ListenableFuture<Response> request(URI uri, String method) {
        return this.request(uri, method, null);
    }

    private ListenableFuture<Response> request(URI uri, String method, Object entity) {
        byte[] entityBytes;
        HashMap headers = Maps.newHashMap();
        headers.put("Helios-Version", Collections.singletonList("0.9.103"));
        if (entity != null) {
            headers.put("Content-Type", Collections.singletonList("application/json"));
            headers.put("Charset", Collections.singletonList("utf-8"));
            entityBytes = Json.asBytesUnchecked(entity);
        } else {
            entityBytes = new byte[]{};
        }
        ListenableFuture<Response> f = this.dispatcher.request(uri, method, entityBytes, headers);
        return Futures.transform(f, (Function)new Function<Response, Response>(){

            public Response apply(Response response) {
                HeliosClient.this.checkProtocolVersionStatus(response);
                return response;
            }
        });
    }

    private void checkProtocolVersionStatus(Response response) {
        VersionCompatibility.Status versionStatus = this.getVersionStatus(response);
        if (versionStatus == null) {
            log.debug("Server didn't return a version header!");
            return;
        }
        String serverVersion = response.header("Helios-Server-Version");
        if (versionStatus == VersionCompatibility.Status.MAYBE && this.versionWarningLogged.compareAndSet(false, true)) {
            log.warn("Your Helios client version [{}] is ahead of the server [{}].  This will probably work ok but there is the potential for weird things.  If in doubt, contact the Helios team if you think the cluster you're connecting to is out of date and should be upgraded.", (Object)"0.9.103", (Object)serverVersion);
        }
    }

    private VersionCompatibility.Status getVersionStatus(Response response) {
        String status = response.header("Helios-Version-Status");
        if (status != null) {
            return VersionCompatibility.Status.valueOf(status);
        }
        return null;
    }

    private <T> ListenableFuture<T> get(URI uri, TypeReference<T> typeReference) {
        return this.get(uri, Json.type(typeReference));
    }

    private <T> ListenableFuture<T> get(URI uri, Class<T> clazz) {
        return this.get(uri, Json.type(clazz));
    }

    private <T> ListenableFuture<T> get(URI uri, JavaType javaType) {
        return Futures.transformAsync(this.request(uri, "GET"), new ConvertResponseToPojo(javaType));
    }

    private ListenableFuture<Integer> put(URI uri) {
        return this.status(this.request(uri, "PUT"));
    }

    public ListenableFuture<JobDeployResponse> deploy(Deployment job, String host) {
        return this.deploy(job, host, "");
    }

    public ListenableFuture<JobDeployResponse> deploy(Deployment job, String host, String token) {
        ImmutableSet deserializeReturnCodes = ImmutableSet.of((Object)200, (Object)404, (Object)405, (Object)400, (Object)403);
        return Futures.transformAsync(this.request(this.uri(this.path("/hosts/%s/jobs/%s", host, job.getJobId()), (Map<String, String>)ImmutableMap.of((Object)"token", (Object)token)), "PUT", job), ConvertResponseToPojo.create(JobDeployResponse.class, (Set<Integer>)deserializeReturnCodes));
    }

    public ListenableFuture<SetGoalResponse> setGoal(Deployment job, String host) {
        return this.setGoal(job, host, "");
    }

    public ListenableFuture<SetGoalResponse> setGoal(Deployment job, String host, String token) {
        return Futures.transformAsync(this.request(this.uri(this.path("/hosts/%s/jobs/%s", host, job.getJobId()), (Map<String, String>)ImmutableMap.of((Object)"token", (Object)token)), "PATCH", job), ConvertResponseToPojo.create(SetGoalResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)404, (Object)403)));
    }

    private ListenableFuture<Integer> status(ListenableFuture<Response> req) {
        return Futures.transform(req, (Function)new Function<Response, Integer>(){

            public Integer apply(Response reply) {
                return reply.status();
            }
        });
    }

    public ListenableFuture<Deployment> deployment(String host, JobId job) {
        return this.get(this.uri(this.path("/hosts/%s/jobs/%s", host, job)), Deployment.class);
    }

    public ListenableFuture<HostStatus> hostStatus(String host) {
        return this.hostStatus(host, Collections.emptyMap());
    }

    public ListenableFuture<HostStatus> hostStatus(String host, Map<String, String> queryParams) {
        return this.get(this.uri(this.path("/hosts/%s/status", host), queryParams), HostStatus.class);
    }

    public ListenableFuture<Map<String, HostStatus>> hostStatuses(List<String> hosts) {
        return this.hostStatuses(hosts, Collections.emptyMap());
    }

    public ListenableFuture<Map<String, HostStatus>> hostStatuses(List<String> hosts, Map<String, String> queryParams) {
        ConvertResponseToPojo converter = ConvertResponseToPojo.create((JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, HostStatus.class), (Set<Integer>)ImmutableSet.of((Object)200));
        return Futures.transformAsync(this.request(this.uri("/hosts/statuses", queryParams), "POST", hosts), converter);
    }

    public ListenableFuture<Integer> registerHost(String host, String id) {
        return this.put(this.uri(this.path("/hosts/%s", host), (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id)));
    }

    public ListenableFuture<JobDeleteResponse> deleteJob(JobId id) {
        return this.deleteJob(id, "");
    }

    public ListenableFuture<JobDeleteResponse> deleteJob(JobId id, String token) {
        return Futures.transformAsync(this.request(this.uri(this.path("/jobs/%s", id), (Map<String, String>)ImmutableMap.of((Object)"token", (Object)token)), "DELETE"), ConvertResponseToPojo.create(JobDeleteResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)404, (Object)400, (Object)403)));
    }

    public ListenableFuture<JobUndeployResponse> undeploy(JobId jobId, String host) {
        return this.undeploy(jobId, host, "");
    }

    public ListenableFuture<JobUndeployResponse> undeploy(JobId jobId, String host, String token) {
        return Futures.transformAsync(this.request(this.uri(this.path("/hosts/%s/jobs/%s", host, jobId), (Map<String, String>)ImmutableMap.of((Object)"token", (Object)token)), "DELETE"), ConvertResponseToPojo.create(JobUndeployResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)404, (Object)400, (Object)403)));
    }

    public ListenableFuture<HostDeregisterResponse> deregisterHost(String host) {
        return Futures.transformAsync(this.request(this.uri(this.path("/hosts/%s", host)), "DELETE"), ConvertResponseToPojo.create(HostDeregisterResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)404)));
    }

    public ListenableFuture<List<String>> listHosts() {
        return this.listHosts((Multimap<String, String>)ImmutableMultimap.of());
    }

    public ListenableFuture<List<String>> listHosts(String namePattern) {
        return this.listHosts((Multimap<String, String>)ImmutableMultimap.of((Object)"namePattern", (Object)namePattern));
    }

    public ListenableFuture<List<String>> listHosts(Set<String> unparsedHostSelectors) {
        HashMultimap query = HashMultimap.create();
        query.putAll((Object)"selector", unparsedHostSelectors);
        return this.listHosts((Multimap<String, String>)query);
    }

    public ListenableFuture<List<String>> listHosts(String namePattern, Set<String> unparsedHostSelectors) {
        HashMultimap query = HashMultimap.create();
        query.put((Object)"namePattern", (Object)namePattern);
        query.putAll((Object)"selector", unparsedHostSelectors);
        return this.listHosts((Multimap<String, String>)query);
    }

    private ListenableFuture<List<String>> listHosts(Multimap<String, String> query) {
        return this.get(this.uri("/hosts/", query), new TypeReference<List<String>>(){});
    }

    public ListenableFuture<List<String>> listMasters() {
        return this.get(this.uri("/masters/"), new TypeReference<List<String>>(){});
    }

    public ListenableFuture<VersionResponse> version() {
        ListenableFuture futureWithFallback = Futures.catching(this.request(this.uri("/version/"), "GET"), Exception.class, (Function)new Function<Exception, Response>(){

            public Response apply(Exception ex) {
                return null;
            }
        });
        return Futures.transformAsync((ListenableFuture)futureWithFallback, (AsyncFunction)new AsyncFunction<Response, VersionResponse>(){

            public ListenableFuture<VersionResponse> apply(@NotNull Response reply) throws Exception {
                String masterVersion = reply == null ? "Unable to connect to master" : (reply.status() == 200 ? Json.read(reply.payload(), String.class) : "Master replied with error code " + reply.status());
                return Futures.immediateFuture((Object)new VersionResponse("0.9.103", masterVersion));
            }
        });
    }

    public ListenableFuture<CreateJobResponse> createJob(Job descriptor) {
        return Futures.transformAsync(this.request(this.uri("/jobs/"), "POST", descriptor), ConvertResponseToPojo.create(CreateJobResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)400)));
    }

    public ListenableFuture<Map<JobId, Job>> jobs(String query) {
        return this.get(this.uri("/jobs", (Map<String, String>)ImmutableMap.of((Object)"q", (Object)query)), new TypeReference<Map<JobId, Job>>(){});
    }

    public ListenableFuture<Map<JobId, Job>> jobs() {
        return this.get(this.uri("/jobs"), new TypeReference<Map<JobId, Job>>(){});
    }

    public ListenableFuture<TaskStatusEvents> jobHistory(JobId jobId) {
        return Futures.transformAsync(this.request(this.uri(this.path("/history/jobs/%s", jobId.toString())), "GET"), ConvertResponseToPojo.create(TaskStatusEvents.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)404)));
    }

    public ListenableFuture<JobStatus> jobStatus(JobId jobId) {
        return this.get(this.uri(this.path("/jobs/%s/status", jobId)), JobStatus.class);
    }

    public ListenableFuture<Map<JobId, JobStatus>> jobStatuses(Set<JobId> jobs) {
        ConvertResponseToPojo converter = ConvertResponseToPojo.create((JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, JobId.class, JobStatus.class), (Set<Integer>)ImmutableSet.of((Object)200));
        return Futures.transformAsync(this.request(this.uri("/jobs/statuses"), "POST", jobs), converter);
    }

    public ListenableFuture<DeploymentGroup> deploymentGroup(String name) {
        return this.get(this.uri("/deployment-group/" + name), new TypeReference<DeploymentGroup>(){});
    }

    public ListenableFuture<List<String>> listDeploymentGroups() {
        return this.get(this.uri("/deployment-group/"), new TypeReference<List<String>>(){});
    }

    public ListenableFuture<DeploymentGroupStatusResponse> deploymentGroupStatus(String name) {
        return this.get(this.uri(this.path("/deployment-group/%s/status", name)), new TypeReference<DeploymentGroupStatusResponse>(){});
    }

    public ListenableFuture<CreateDeploymentGroupResponse> createDeploymentGroup(DeploymentGroup descriptor) {
        return Futures.transformAsync(this.request(this.uri("/deployment-group/"), "POST", descriptor), ConvertResponseToPojo.create(CreateDeploymentGroupResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)400)));
    }

    public ListenableFuture<RemoveDeploymentGroupResponse> removeDeploymentGroup(String name) {
        return Futures.transformAsync(this.request(this.uri("/deployment-group/" + name), "DELETE"), ConvertResponseToPojo.create(RemoveDeploymentGroupResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)400)));
    }

    public ListenableFuture<RollingUpdateResponse> rollingUpdate(String deploymentGroupName, JobId job, RolloutOptions options) {
        return Futures.transformAsync(this.request(this.uri(this.path("/deployment-group/%s/rolling-update", deploymentGroupName)), "POST", new RollingUpdateRequest(job, options)), ConvertResponseToPojo.create(RollingUpdateResponse.class, (Set<Integer>)ImmutableSet.of((Object)200, (Object)400)));
    }

    public ListenableFuture<Integer> stopDeploymentGroup(String deploymentGroupName) {
        return this.status(this.request(this.uri(this.path("/deployment-group/%s/stop", deploymentGroupName)), "POST"));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static HeliosClient create(String domain, String user) {
        return HeliosClient.newBuilder().setDomain(domain).setUser(user).build();
    }

    public static class Builder {
        private static final String HELIOS_CERT_PATH = "HELIOS_CERT_PATH";
        private static final AtomicInteger clientCounter = new AtomicInteger(0);
        private String user;
        private ClientCertificatePath clientCertificatePath;
        private Supplier<List<Endpoint>> endpointSupplier;
        private boolean sslHostnameVerification = true;
        private ListeningScheduledExecutorService executorService;
        private boolean shutDownExecutorOnClose = true;
        private int httpTimeout = 10000;
        private long requestRetryTimeout = 60000L;

        private Builder() {
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setDomain(String domain) {
            return this.setEndpointSupplier(Endpoints.of(Resolver.supplier("helios", domain)));
        }

        public Builder setEndpoints(List<URI> endpoints) {
            return this.setEndpointSupplier((Supplier<List<Endpoint>>)Suppliers.ofInstance(Endpoints.of(endpoints)));
        }

        public Builder setEndpoints(URI ... endpoints) {
            return this.setEndpointSupplier((Supplier<List<Endpoint>>)Suppliers.ofInstance(Endpoints.of(Arrays.asList(endpoints))));
        }

        public Builder setEndpoints(String ... endpoints) {
            return this.setEndpointStrings(Arrays.asList(endpoints));
        }

        public Builder setEndpointStrings(List<String> endpoints) {
            ArrayList uris = Lists.newArrayList();
            for (String endpoint : endpoints) {
                uris.add(URI.create(endpoint));
            }
            return this.setEndpoints(uris);
        }

        public Builder setEndpointSupplier(Supplier<List<Endpoint>> endpointSupplier) {
            this.endpointSupplier = endpointSupplier;
            return this;
        }

        public Builder setSslHostnameVerification(boolean enabled) {
            this.sslHostnameVerification = enabled;
            return this;
        }

        public Builder setClientCertificatePath(ClientCertificatePath clientCertificatePath) {
            this.clientCertificatePath = clientCertificatePath;
            return this;
        }

        public Builder setExecutorService(ScheduledExecutorService executorService) {
            this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorService);
            return this;
        }

        public Builder setShutDownExecutorOnClose(boolean shutDownExecutorOnClose) {
            this.shutDownExecutorOnClose = shutDownExecutorOnClose;
            return this;
        }

        public Builder setHttpTimeout(int timeout, TimeUnit unit) {
            this.httpTimeout = (int)unit.toMillis(timeout);
            return this;
        }

        public Builder setRetryTimeout(int timeout, TimeUnit unit) {
            this.requestRetryTimeout = (int)unit.toMillis(timeout);
            return this;
        }

        public HeliosClient build() {
            return new HeliosClient(this.user, this.createDispatcher());
        }

        private static ListeningScheduledExecutorService defaultExecutorService() {
            int clientCount = clientCounter.incrementAndGet();
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("helios-client-" + clientCount + "-thread-%d").build();
            ScheduledThreadPoolExecutor stpe = new ScheduledThreadPoolExecutor(4, threadFactory);
            ScheduledExecutorService exitingExecutor = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)stpe, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            return MoreExecutors.listeningDecorator((ScheduledExecutorService)exitingExecutor);
        }

        private RequestDispatcher createDispatcher() {
            if (this.executorService == null) {
                this.executorService = Builder.defaultExecutorService();
            }
            DefaultRequestDispatcher dispatcher = new DefaultRequestDispatcher(this.createHttpConnector(this.sslHostnameVerification), (ListeningExecutorService)this.executorService, this.shutDownExecutorOnClose);
            return RetryingRequestDispatcher.forDispatcher(dispatcher).setExecutor((ScheduledExecutorService)this.executorService).setRetryTimeout(this.requestRetryTimeout, TimeUnit.MILLISECONDS).build();
        }

        private HttpConnector createHttpConnector(boolean sslHostnameVerification) {
            String heliosCertPath;
            EndpointIterator endpointIterator = EndpointIterator.of((List)this.endpointSupplier.get());
            if (!endpointIterator.hasNext()) {
                throw new IllegalStateException("no endpoints found to connect to, check your configuration");
            }
            DefaultHttpConnector connector = new DefaultHttpConnector(endpointIterator, this.httpTimeout, sslHostnameVerification);
            Optional agentProxyOpt = Optional.absent();
            try {
                agentProxyOpt = Optional.of((Object)AgentProxies.newInstance());
            }
            catch (RuntimeException e) {
                log.debug("Exception (possibly benign) while loading AgentProxy", (Throwable)e);
            }
            if (this.clientCertificatePath == null && !Strings.isNullOrEmpty((String)(heliosCertPath = System.getenv(HELIOS_CERT_PATH)))) {
                Path certPath = Paths.get(heliosCertPath, "cert.pem");
                Path keyPath = Paths.get(heliosCertPath, "key.pem");
                if (certPath.toFile().canRead() && keyPath.toFile().canRead()) {
                    this.clientCertificatePath = new ClientCertificatePath(certPath, keyPath);
                } else {
                    log.warn("{} is set to {}, but {} and/or {} do not exist or cannot be read. Will not send client certificate in HeliosClient requests.", new Object[]{HELIOS_CERT_PATH, heliosCertPath, certPath, keyPath});
                }
            }
            return new AuthenticatingHttpConnector(this.user, (Optional<AgentProxy>)agentProxyOpt, (Optional<ClientCertificatePath>)Optional.fromNullable((Object)this.clientCertificatePath), endpointIterator, connector);
        }
    }

    private static final class ConvertResponseToPojo<T>
    implements AsyncFunction<Response, T> {
        private final JavaType javaType;
        private final Set<Integer> decodeableStatusCodes;

        private ConvertResponseToPojo(JavaType javaType) {
            this(javaType, (Set<Integer>)ImmutableSet.of((Object)200));
        }

        public ConvertResponseToPojo(JavaType type, Set<Integer> decodeableStatusCodes) {
            this.javaType = type;
            this.decodeableStatusCodes = decodeableStatusCodes;
        }

        public static <T> ConvertResponseToPojo<T> create(JavaType type, Set<Integer> decodeableStatusCodes) {
            return new ConvertResponseToPojo<T>(type, decodeableStatusCodes);
        }

        public static <T> ConvertResponseToPojo<T> create(Class<T> clazz, Set<Integer> decodeableStatusCodes) {
            return new ConvertResponseToPojo<T>(Json.type(clazz), decodeableStatusCodes);
        }

        public ListenableFuture<T> apply(@NotNull Response reply) throws HeliosException {
            Object result;
            if (reply.status() == 404 && !this.decodeableStatusCodes.contains(404)) {
                return Futures.immediateFuture(null);
            }
            if (!this.decodeableStatusCodes.contains(reply.status())) {
                throw new HeliosException("request failed: " + reply);
            }
            if (reply.payload().length == 0) {
                throw new HeliosException("bad reply: " + reply);
            }
            try {
                result = Json.read(reply.payload(), this.javaType);
            }
            catch (IOException e) {
                throw new HeliosException("bad reply: " + reply, e);
            }
            return Futures.immediateFuture(result);
        }
    }
}

