/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.common.base.Preconditions;
import java.nio.file.Path;

public class ClientCertificatePath {
    private final Path certificatePath;
    private final Path keyPath;

    public ClientCertificatePath(Path certificatePath, Path keyPath) {
        this.certificatePath = ClientCertificatePath.checkExists(certificatePath);
        this.keyPath = ClientCertificatePath.checkExists(keyPath);
    }

    private static Path checkExists(Path path) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.toFile().canRead(), (Object)(path + " does not exist or cannot be read"));
        return path;
    }

    public Path getCertificatePath() {
        return this.certificatePath;
    }

    public Path getKeyPath() {
        return this.keyPath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClientCertificatePath that = (ClientCertificatePath)obj;
        if (!this.certificatePath.equals(that.certificatePath)) {
            return false;
        }
        return this.keyPath.equals(that.keyPath);
    }

    public int hashCode() {
        int result = this.certificatePath.hashCode();
        result = 31 * result + this.keyPath.hashCode();
        return result;
    }

    public String toString() {
        return "ClientCertificatePath{certificatePath=" + this.certificatePath + ", keyPath=" + this.keyPath + '}';
    }
}

