/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.com.spotify.dns;

import com.google.common.primitives.Ints;
import com.spotify.helios.client.shaded.com.spotify.dns.CachingLookupFactory;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.LookupFactory;
import com.spotify.helios.client.shaded.com.spotify.dns.MeteredDnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.RetainingDnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.SimpleLookupFactory;
import com.spotify.helios.client.shaded.com.spotify.dns.XBillDnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.statistics.DnsReporter;
import com.spotify.helios.client.shaded.org.xbill.DNS.Lookup;
import java.util.concurrent.TimeUnit;

public final class DnsSrvResolvers {
    private static final int DEFAULT_DNS_TIMEOUT_SECONDS = 5;

    public static DnsSrvResolverBuilder newBuilder() {
        return new DnsSrvResolverBuilder();
    }

    private DnsSrvResolvers() {
    }

    public static final class DnsSrvResolverBuilder {
        private final DnsReporter reporter;
        private final boolean retainData;
        private final boolean cacheLookups;
        private final long dnsLookupTimeoutMillis;

        private DnsSrvResolverBuilder() {
            this(null, false, false, TimeUnit.SECONDS.toMillis(5L));
        }

        private DnsSrvResolverBuilder(DnsReporter reporter, boolean retainData, boolean cacheLookups, long dnsLookupTimeoutMillis) {
            this.reporter = reporter;
            this.retainData = retainData;
            this.cacheLookups = cacheLookups;
            this.dnsLookupTimeoutMillis = dnsLookupTimeoutMillis;
        }

        public DnsSrvResolver build() {
            int timeoutSecs = Ints.checkedCast((long)TimeUnit.MILLISECONDS.toSeconds(this.dnsLookupTimeoutMillis));
            int millisRemainder = Ints.checkedCast((long)(this.dnsLookupTimeoutMillis - TimeUnit.SECONDS.toMillis(timeoutSecs)));
            Lookup.getDefaultResolver().setTimeout(timeoutSecs, millisRemainder);
            LookupFactory lookupFactory = new SimpleLookupFactory();
            if (this.cacheLookups) {
                lookupFactory = new CachingLookupFactory(lookupFactory);
            }
            DnsSrvResolver result = new XBillDnsSrvResolver(lookupFactory);
            if (this.reporter != null) {
                result = new MeteredDnsSrvResolver(result, this.reporter);
            }
            if (this.retainData) {
                result = new RetainingDnsSrvResolver(result);
            }
            return result;
        }

        public DnsSrvResolverBuilder metered(DnsReporter reporter) {
            return new DnsSrvResolverBuilder(reporter, this.retainData, this.cacheLookups, this.dnsLookupTimeoutMillis);
        }

        public DnsSrvResolverBuilder retainingDataOnFailures(boolean retainData) {
            return new DnsSrvResolverBuilder(this.reporter, retainData, this.cacheLookups, this.dnsLookupTimeoutMillis);
        }

        public DnsSrvResolverBuilder cachingLookups(boolean cacheLookups) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, cacheLookups, this.dnsLookupTimeoutMillis);
        }

        public DnsSrvResolverBuilder dnsLookupTimeoutMillis(long dnsLookupTimeoutMillis) {
            return new DnsSrvResolverBuilder(this.reporter, this.retainData, this.cacheLookups, dnsLookupTimeoutMillis);
        }
    }
}

