/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.TaskStatus;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JobStatus {
    private final Job job;
    private final Map<String, TaskStatus> taskStatuses;
    private final Map<String, Deployment> deployments;

    public JobStatus(@JsonProperty(value="job") Job job, @JsonProperty(value="taskStatuses") Map<String, TaskStatus> taskStatuses, @JsonProperty(value="deployments") Map<String, Deployment> deployments) {
        this.job = job;
        this.taskStatuses = taskStatuses;
        this.deployments = deployments;
    }

    public JobStatus(Builder builder) {
        this.job = builder.job;
        this.taskStatuses = builder.taskStatuses;
        this.deployments = builder.deployments;
    }

    public Job getJob() {
        return this.job;
    }

    public Map<String, TaskStatus> getTaskStatuses() {
        return this.taskStatuses;
    }

    public Map<String, Deployment> getDeployments() {
        return this.deployments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobStatus jobStatus = (JobStatus)obj;
        if (this.deployments != null ? !this.deployments.equals(jobStatus.deployments) : jobStatus.deployments != null) {
            return false;
        }
        if (this.job != null ? !this.job.equals(jobStatus.job) : jobStatus.job != null) {
            return false;
        }
        return !(this.taskStatuses != null ? !this.taskStatuses.equals(jobStatus.taskStatuses) : jobStatus.taskStatuses != null);
    }

    public int hashCode() {
        int result = this.job != null ? this.job.hashCode() : 0;
        result = 31 * result + (this.taskStatuses != null ? this.taskStatuses.hashCode() : 0);
        result = 31 * result + (this.deployments != null ? this.deployments.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JobStatus{job=" + this.job + ", taskStatuses=" + this.taskStatuses + ", deployments=" + this.deployments + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Job job;
        private Map<String, TaskStatus> taskStatuses;
        public Map<String, Deployment> deployments;

        public Builder setJob(Job job) {
            this.job = job;
            return this;
        }

        public Builder setTaskStatuses(Map<String, TaskStatus> taskStatuses) {
            this.taskStatuses = ImmutableMap.copyOf(taskStatuses);
            return this;
        }

        public Builder setDeployments(Map<String, Deployment> deployments) {
            this.deployments = ImmutableMap.copyOf(deployments);
            return this;
        }

        public JobStatus build() {
            return new JobStatus(this);
        }
    }
}

