/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.com.spotify.dns;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.LookupResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class RetainingDnsSrvResolver
implements DnsSrvResolver {
    private final DnsSrvResolver delegate;
    private final Map<String, List<LookupResult>> cache;

    RetainingDnsSrvResolver(DnsSrvResolver delegate) {
        this.delegate = (DnsSrvResolver)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.cache = new ConcurrentHashMap<String, List<LookupResult>>();
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        try {
            List<LookupResult> nodes = this.delegate.resolve(fqdn);
            if (nodes.isEmpty()) {
                List<LookupResult> cached = this.cache.get(fqdn);
                return cached != null ? cached : nodes;
            }
            this.cache.put(fqdn, nodes);
            return nodes;
        }
        catch (Exception e) {
            if (this.cache.containsKey(fqdn)) {
                return this.cache.get(fqdn);
            }
            throw Throwables.propagate((Throwable)e);
        }
    }
}

