/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client.shaded.org.xbill.DNS;

import com.spotify.helios.client.shaded.org.xbill.DNS.Compression;
import com.spotify.helios.client.shaded.org.xbill.DNS.DNSInput;
import com.spotify.helios.client.shaded.org.xbill.DNS.DNSOutput;
import com.spotify.helios.client.shaded.org.xbill.DNS.Name;
import com.spotify.helios.client.shaded.org.xbill.DNS.Record;
import com.spotify.helios.client.shaded.org.xbill.DNS.Tokenizer;
import com.spotify.helios.client.shaded.org.xbill.DNS.Type;
import java.io.IOException;
import java.util.BitSet;

public class NXTRecord
extends Record {
    private static final long serialVersionUID = -8851454400765507520L;
    private Name next;
    private BitSet bitmap;

    NXTRecord() {
    }

    Record getObject() {
        return new NXTRecord();
    }

    public NXTRecord(Name name, int dclass, long ttl, Name next, BitSet bitmap) {
        super(name, 30, dclass, ttl);
        this.next = NXTRecord.checkName("next", next);
        this.bitmap = bitmap;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.next = new Name(in);
        this.bitmap = new BitSet();
        int bitmapLength = in.remaining();
        for (int i = 0; i < bitmapLength; ++i) {
            int t = in.readU8();
            for (int j = 0; j < 8; ++j) {
                if ((t & 1 << 7 - j) == 0) continue;
                this.bitmap.set(i * 8 + j);
            }
        }
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.next = st.getName(origin);
        this.bitmap = new BitSet();
        while ((t = st.get()).isString()) {
            int typecode = Type.value(t.value, true);
            if (typecode <= 0 || typecode > 128) {
                throw st.exception("Invalid type: " + t.value);
            }
            this.bitmap.set(typecode);
        }
        st.unget();
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.next);
        int length = this.bitmap.length();
        for (int i = 0; i < length; i = (int)((short)(i + 1))) {
            if (!this.bitmap.get(i)) continue;
            sb.append(" ");
            sb.append(Type.string(i));
        }
        return sb.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.next.toWire(out, null, canonical);
        int length = this.bitmap.length();
        int t = 0;
        for (int i = 0; i < length; ++i) {
            t |= this.bitmap.get(i) ? 1 << 7 - i % 8 : 0;
            if (i % 8 != 7 && i != length - 1) continue;
            out.writeU8(t);
            t = 0;
        }
    }
}

