/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsSrvResolver;
import com.spotify.helios.client.shaded.com.spotify.dns.DnsSrvResolvers;
import com.spotify.helios.client.shaded.com.spotify.dns.LookupResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public abstract class Resolver {
    private static final String HTTPS_SRV_FORMAT = Resolver.env("HELIOS_HTTPS_SRV_FORMAT", "_%s._https.%s");
    private static final String HTTP_SRV_FORMAT = Resolver.env("HELIOS_HTTP_SRV_FORMAT", "_%s._http.%s");
    private static final DnsSrvResolver DEFAULT_RESOLVER = DnsSrvResolvers.newBuilder().build();

    private static String env(String name, String defaultValue) {
        return (String)Optional.fromNullable((Object)System.getenv(name)).or((Object)defaultValue);
    }

    public static Supplier<List<URI>> supplier(String srvName, String domain) {
        return Resolver.supplier(srvName, domain, DEFAULT_RESOLVER);
    }

    static Supplier<List<URI>> supplier(final String srvName, final String domain, final DnsSrvResolver resolver) {
        return new Supplier<List<URI>>(){

            public List<URI> get() {
                List uris = Resolver.resolve(srvName, "https", domain, resolver);
                if (uris.isEmpty()) {
                    uris = Resolver.resolve(srvName, "http", domain, resolver);
                }
                return uris;
            }
        };
    }

    private static List<URI> resolve(String srvName, String protocol, String domain, DnsSrvResolver resolver) {
        String name;
        switch (protocol) {
            case "https": {
                name = Resolver.httpsSrv(srvName, domain);
                break;
            }
            case "http": {
                name = Resolver.httpSrv(srvName, domain);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid protocol: %s. Helios SRV record can only be https or http.", protocol));
            }
        }
        List<LookupResult> lookupResults = resolver.resolve(name);
        ImmutableList.Builder endpoints = ImmutableList.builder();
        for (LookupResult result : lookupResults) {
            endpoints.add((Object)Resolver.protocol(protocol, result.host(), result.port()));
        }
        return endpoints.build();
    }

    private static URI protocol(String protocol, String host, int port) {
        URI endpoint;
        try {
            endpoint = new URI(protocol, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return endpoint;
    }

    private static String httpsSrv(String name, String domain) {
        return String.format(HTTPS_SRV_FORMAT, name, domain);
    }

    private static String httpSrv(String name, String domain) {
        return String.format(HTTP_SRV_FORMAT, name, domain);
    }
}

