/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.spotify.helios.common.descriptors.HealthCheck;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HttpHealthCheck
extends HealthCheck {
    private final String path;
    private final String port;

    public HttpHealthCheck(@JsonProperty(value="path") String path, @JsonProperty(value="port") String port) {
        super("http");
        this.path = path;
        this.port = port;
    }

    private HttpHealthCheck(Builder builder) {
        super("http");
        this.path = builder.path;
        this.port = builder.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getPort() {
        return this.port;
    }

    public static HttpHealthCheck of(String port, String path) {
        return HttpHealthCheck.newBuilder().setPort(port).setPath(path).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpHealthCheck that = (HttpHealthCheck)obj;
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.port != null ? !this.port.equals(that.port) : that.port != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "HttpHealthCheck{path='" + this.path + '\'' + ", port='" + this.port + '\'' + "} " + super.toString();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private String port;

        public String getPath() {
            return this.path;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public String getPort() {
            return this.port;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public HttpHealthCheck build() {
            if (Strings.isNullOrEmpty((String)this.path)) {
                throw new IllegalArgumentException("You must specify a URL path for an HTTP health check.");
            }
            if (!this.path.startsWith("/")) {
                throw new IllegalArgumentException("The path for an HTTP health check must begin with '/'.");
            }
            if (Strings.isNullOrEmpty((String)this.port)) {
                throw new IllegalArgumentException("You must specify a port for an HTTP health check.");
            }
            return new HttpHealthCheck(this);
        }
    }
}

