/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCredentialsAccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(GoogleCredentialsAccessTokenProvider.class);

    public static AccessToken getAccessToken() throws IOException {
        File file;
        GoogleCredentials credentials = null;
        String googleCredentialsPath = System.getenv("HELIOS_GOOGLE_CREDENTIALS");
        if (googleCredentialsPath != null && (file = new File(googleCredentialsPath)).exists()) {
            FileInputStream s = new FileInputStream(file);
            credentials = GoogleCredentials.fromStream((InputStream)s);
            log.debug("Using Google Credentials from file: " + file.getAbsolutePath());
        }
        if (credentials == null) {
            credentials = GoogleCredentials.getApplicationDefault();
            log.debug("Using Google Application Default Credentials");
        }
        if (credentials == null) {
            return null;
        }
        credentials.refresh();
        return credentials.getAccessToken();
    }
}

