/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.spotify.helios.common.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;

public class Json {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final ObjectWriter NORMALIZING_OBJECT_WRITER = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.ALWAYS)).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).writer();
    private static final ObjectWriter PRETTY_OBJECT_WRITER = new ObjectMapper().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).writerWithDefaultPrettyPrinter();
    private static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};

    public static byte[] asBytes(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsBytes(value);
    }

    public static byte[] asBytesUnchecked(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String asString(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(value);
    }

    public static String asStringUnchecked(Object value) {
        try {
            return Json.asString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String asPrettyString(Object value) throws JsonProcessingException {
        return PRETTY_OBJECT_WRITER.writeValueAsString(value);
    }

    public static String asPrettyStringUnchecked(Object value) {
        try {
            return Json.asPrettyString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String asNormalizedString(Object value) throws JsonProcessingException {
        return NORMALIZING_OBJECT_WRITER.writeValueAsString(value);
    }

    public static String asNormalizedStringUnchecked(Object value) {
        try {
            return Json.asNormalizedString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T read(String content, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(content, clazz);
    }

    public static <T> T read(String content, TypeReference<?> typeReference) throws IOException {
        return (T)OBJECT_MAPPER.readValue(content, typeReference);
    }

    public static <T> T read(String content, JavaType javaType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(content, javaType);
    }

    public static <T> T read(byte[] bytes, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(bytes, clazz);
    }

    public static <T> T read(byte[] bytes, TypeReference<?> typeReference) throws IOException {
        return (T)OBJECT_MAPPER.readValue(bytes, typeReference);
    }

    public static <T> T read(byte[] bytes, JavaType javaType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(bytes, javaType);
    }

    public static <T> T readUnchecked(String content, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readUnchecked(String content, TypeReference<?> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readUnchecked(String content, JavaType javaType) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readUnchecked(byte[] bytes, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readUnchecked(byte[] bytes, TypeReference<?> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readUnchecked(byte[] bytes, JavaType javaType) {
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MappingIterator<Map<String, Object>> readValues(InputStream stream, TypeReference<Map<String, Object>> typeReference) throws IOException {
        JsonParser parser = OBJECT_MAPPER.getFactory().createParser(stream);
        return OBJECT_MAPPER.readValues(parser, typeReference);
    }

    public static MappingIterator<JsonNode> readValues(InputStream stream) throws IOException {
        JsonParser parser = OBJECT_MAPPER.getFactory().createParser(stream);
        return OBJECT_MAPPER.readValues(parser, JsonNode.class);
    }

    public static JsonNode readTree(byte[] bytes) throws IOException {
        return OBJECT_MAPPER.readTree(bytes);
    }

    public static JsonNode readTree(String content) throws IOException {
        return OBJECT_MAPPER.readTree(content);
    }

    public static JsonNode readTree(File file) throws IOException {
        return OBJECT_MAPPER.readTree(file);
    }

    public static JsonNode readTreeUnchecked(byte[] bytes) {
        try {
            return Json.readTree(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode readTreeUnchecked(String content) {
        try {
            return Json.readTree(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode readTreeUnchecked(File file) {
        try {
            return Json.readTree(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JavaType type(Type type) {
        return OBJECT_MAPPER.constructType(type);
    }

    public static JavaType type(TypeReference<?> typeReference) {
        return OBJECT_MAPPER.getTypeFactory().constructType(typeReference);
    }

    public static TypeFactory typeFactory() {
        return OBJECT_MAPPER.getTypeFactory();
    }

    public static ObjectReader reader() {
        return OBJECT_MAPPER.reader();
    }

    public static ObjectWriter writer() {
        return OBJECT_MAPPER.writer();
    }

    public static byte[] sha1digest(Object obj) throws IOException {
        String json = NORMALIZING_OBJECT_WRITER.writeValueAsString(obj);
        Map map = (Map)OBJECT_MAPPER.readValue(json, MAP_TYPE);
        return Json.sha1digest(map);
    }

    public static byte[] sha1digest(Map<String, ?> obj) throws IOException {
        byte[] bytes = NORMALIZING_OBJECT_WRITER.writeValueAsBytes(obj);
        return Hash.sha1digest(bytes);
    }
}

