/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

class Response {
    private final String method;
    private final URI uri;
    private final int status;
    private final byte[] payload;
    private final Map<String, List<String>> headers;

    public Response(String method, URI uri, int status, byte[] payload, Map<String, List<String>> headers) {
        this.method = method;
        this.uri = uri;
        this.status = status;
        this.payload = payload;
        this.headers = headers;
    }

    public String toString() {
        return "Response{method='" + this.method + '\'' + ", uri=" + this.uri + ", status=" + this.status + ", payload='" + Response.decode(this.payload) + '\'' + ", headers=" + this.headers + '}';
    }

    private static String decode(byte[] payload) {
        if (payload == null) {
            return "";
        }
        int length = Math.min(payload.length, 1024);
        return new String(payload, 0, length, StandardCharsets.UTF_8);
    }

    public String method() {
        return this.method;
    }

    public URI uri() {
        return this.uri;
    }

    public int status() {
        return this.status;
    }

    public byte[] payload() {
        return this.payload;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String header(String name) {
        List<String> headerValues = this.headers.get(name);
        return headerValues == null || headerValues.isEmpty() ? null : headerValues.get(0);
    }
}

