/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RolloutOptions {
    private static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toSeconds(5L);
    private static final int DEFAULT_PARALLELISM = 1;
    static final boolean DEFAULT_MIGRATE = false;
    private static final boolean DEFAULT_OVERLAP = false;
    static final String DEFAULT_TOKEN = "";
    static final boolean DEFAULT_IGNORE_FAILURES = false;
    private static final RolloutOptions DEFAULT = RolloutOptions.newBuilder().setTimeout(DEFAULT_TIMEOUT).setParallelism(1).setMigrate(false).setOverlap(false).setToken("").setIgnoreFailures(false).build();
    private final Long timeout;
    private final Integer parallelism;
    private final Boolean migrate;
    private final Boolean overlap;
    private final String token;
    private final Boolean ignoreFailures;

    private RolloutOptions(@JsonProperty(value="timeout") @Nullable Long timeout, @JsonProperty(value="parallelism") @Nullable Integer parallelism, @JsonProperty(value="migrate") @Nullable Boolean migrate, @JsonProperty(value="overlap") @Nullable Boolean overlap, @JsonProperty(value="token") @Nullable String token, @JsonProperty(value="ignoreFailures") @Nullable Boolean ignoreFailures) {
        this.timeout = timeout;
        this.parallelism = parallelism;
        this.migrate = migrate;
        this.overlap = overlap;
        this.token = token;
        this.ignoreFailures = ignoreFailures;
    }

    public static RolloutOptions getDefault() {
        return DEFAULT;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().setTimeout(this.timeout).setParallelism(this.parallelism).setMigrate(this.migrate).setOverlap(this.overlap).setToken(this.token).setIgnoreFailures(this.ignoreFailures);
    }

    public RolloutOptions withFallback(RolloutOptions that) {
        return RolloutOptions.newBuilder().setTimeout((Long)MoreObjects.firstNonNull((Object)this.timeout, (Object)that.timeout)).setParallelism((Integer)MoreObjects.firstNonNull((Object)this.parallelism, (Object)that.parallelism)).setMigrate((Boolean)MoreObjects.firstNonNull((Object)this.migrate, (Object)that.migrate)).setOverlap((Boolean)MoreObjects.firstNonNull((Object)this.overlap, (Object)that.overlap)).setToken((String)MoreObjects.firstNonNull((Object)this.token, (Object)that.token)).setIgnoreFailures((Boolean)MoreObjects.firstNonNull((Object)this.ignoreFailures, (Object)that.ignoreFailures)).build();
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Integer getParallelism() {
        return this.parallelism;
    }

    @Nullable
    public Boolean getMigrate() {
        return this.migrate;
    }

    @Nullable
    public Boolean getOverlap() {
        return this.overlap;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    @Nullable
    public Boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RolloutOptions that = (RolloutOptions)obj;
        return Objects.equals(this.migrate, that.migrate) && Objects.equals(this.parallelism, that.parallelism) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.overlap, that.overlap) && Objects.equals(this.token, that.token) && Objects.equals(this.ignoreFailures, that.ignoreFailures);
    }

    public int hashCode() {
        return Objects.hash(this.timeout, this.parallelism, this.migrate, this.overlap, this.token, this.ignoreFailures);
    }

    public String toString() {
        return "RolloutOptions{timeout=" + this.timeout + ", parallelism=" + this.parallelism + ", migrate=" + this.migrate + ", overlap=" + this.overlap + ", token=" + this.token + ", ignoreFailures=" + this.ignoreFailures + '}';
    }

    public static class Builder {
        private Long timeout;
        private Integer parallelism;
        private Boolean migrate;
        private Boolean overlap;
        private String token;
        private Boolean ignoreFailures;

        public Builder setTimeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setParallelism(Integer parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder setMigrate(Boolean migrate) {
            this.migrate = migrate;
            return this;
        }

        public Builder setOverlap(Boolean overlap) {
            this.overlap = overlap;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setIgnoreFailures(Boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this;
        }

        public RolloutOptions build() {
            return new RolloutOptions(this.timeout, this.parallelism, this.migrate, this.overlap, this.token, this.ignoreFailures);
        }
    }
}

