/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleCredentialsAccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger(GoogleCredentialsAccessTokenProvider.class);

    GoogleCredentialsAccessTokenProvider() {
    }

    static AccessToken getAccessToken(List<String> scopes) throws IOException {
        File file;
        GoogleCredentials credentials = null;
        String googleCredentialsPath = System.getenv("HELIOS_GOOGLE_CREDENTIALS");
        if (googleCredentialsPath != null && (file = new File(googleCredentialsPath)).exists()) {
            FileInputStream s = new FileInputStream(file);
            credentials = GoogleCredentials.fromStream((InputStream)s);
            log.debug("Using Google Credentials from file: " + file.getAbsolutePath());
        }
        if (credentials == null) {
            credentials = GoogleCredentials.getApplicationDefault();
            log.debug("Using Google Application Default Credentials");
        }
        return GoogleCredentialsAccessTokenProvider.getAccessToken(credentials, scopes);
    }

    @VisibleForTesting
    static AccessToken getAccessToken(GoogleCredentials credentials, List<String> scopes) throws IOException {
        if (credentials == null) {
            return null;
        }
        GoogleCredentials newCredentials = scopes.isEmpty() ? credentials : credentials.createScoped(scopes);
        newCredentials.refresh();
        return newCredentials.getAccessToken();
    }

    static AccessToken getAccessToken() throws IOException {
        return GoogleCredentialsAccessTokenProvider.getAccessToken(Collections.singletonList("https://www.googleapis.com/auth/cloud-platform"));
    }
}

