/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.helios.common.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class Descriptor {
    public String toJsonString() {
        return Json.asStringUnchecked(this);
    }

    public byte[] toJsonBytes() {
        try {
            return Json.asBytes(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Descriptor> T parse(byte[] bytes, Class<T> clazz) throws IOException {
        return (T)((Descriptor)Json.read(bytes, clazz));
    }

    public static <T extends Descriptor> T parse(String value, Class<T> clazz) throws IOException {
        return Descriptor.parse(value.getBytes(StandardCharsets.UTF_8), clazz);
    }
}

