/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.helios.common.descriptors.HealthCheck;
import java.util.Arrays;
import java.util.List;

public class ExecHealthCheck
extends HealthCheck {
    private final List<String> command;

    public ExecHealthCheck(@JsonProperty(value="command") List<String> command) {
        super("exec");
        this.command = command;
    }

    private ExecHealthCheck(Builder builder) {
        super("exec");
        this.command = builder.command;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public static ExecHealthCheck of(String ... command) {
        return ExecHealthCheck.of(Arrays.asList(command));
    }

    public static ExecHealthCheck of(List<String> command) {
        return ExecHealthCheck.newBuilder().setCommand(command).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExecHealthCheck that = (ExecHealthCheck)obj;
        return !(this.command != null ? !this.command.equals(that.command) : that.command != null);
    }

    public int hashCode() {
        return this.command != null ? this.command.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ExecHealthCheck{command=" + this.command + "} " + super.toString();
    }

    static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> command;

        public List<String> getCommand() {
            return this.command;
        }

        public Builder setCommand(List<String> command) {
            this.command = command;
            return this;
        }

        public ExecHealthCheck build() {
            if (this.command == null || this.command.isEmpty()) {
                throw new IllegalArgumentException("You must specify a command for an exec health check.");
            }
            return new ExecHealthCheck(this);
        }
    }
}

