/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.client;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleCredentialsAccessTokenSupplier
implements Supplier<Optional<AccessToken>> {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCredentialsAccessTokenSupplier.class);
    static final List<String> DEFAULT_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform.read-only", (Object)"https://www.googleapis.com/auth/userinfo.email");
    private boolean enabled;
    private AccessToken staticToken;
    private List<String> tokenScopes;
    private GoogleCredentials credentials;
    private final Object lock = new byte[0];

    GoogleCredentialsAccessTokenSupplier(boolean enabled, AccessToken staticToken, List<String> tokenScopes) {
        this(enabled, staticToken, tokenScopes, null);
    }

    @VisibleForTesting
    GoogleCredentialsAccessTokenSupplier(boolean enabled, AccessToken staticToken, List<String> tokenScopes, GoogleCredentials credentials) {
        this.enabled = enabled;
        this.staticToken = staticToken;
        this.tokenScopes = tokenScopes;
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<AccessToken> get() {
        Optional tokenOpt = Optional.absent();
        if (this.enabled) {
            if (this.staticToken != null) {
                tokenOpt = Optional.of((Object)this.staticToken);
            } else {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.credentials == null) {
                            this.credentials = GoogleCredentialsAccessTokenSupplier.getCredentialsWithScopes(this.tokenScopes);
                        }
                        this.credentials.refreshIfExpired();
                    }
                    tokenOpt = Optional.of((Object)this.credentials.getAccessToken());
                }
                catch (IOException | RuntimeException e) {
                    LOG.debug("Exception (possibly benign) while loading Google Credentials", (Throwable)e);
                    return Optional.absent();
                }
            }
        }
        return tokenOpt;
    }

    private static GoogleCredentials getCredentialsWithScopes(List<String> scopes) throws IOException {
        File file;
        GoogleCredentials credentials = null;
        String googleCredentialsPath = System.getenv("HELIOS_GOOGLE_CREDENTIALS");
        if (googleCredentialsPath != null && (file = new File(googleCredentialsPath)).exists()) {
            try (FileInputStream s = new FileInputStream(file);){
                credentials = GoogleCredentials.fromStream((InputStream)s);
                LOG.info("Using Google Credentials from file: " + file.getAbsolutePath());
            }
        }
        if (credentials == null) {
            credentials = GoogleCredentials.getApplicationDefault();
            LOG.info("Using Google Application Default Credentials");
        }
        return scopes.isEmpty() ? credentials : credentials.createScoped(scopes);
    }
}

