/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import org.jetbrains.annotations.NotNull;

public class PomVersion
implements Comparable<PomVersion> {
    private final boolean isSnapshot;
    private final int major;
    private final int minor;
    private final int patch;

    public PomVersion(@JsonProperty(value="snapshot") boolean isSnapshot, @JsonProperty(value="major") int major, @JsonProperty(value="minor") int minor, @JsonProperty(value="patch") int patch) {
        this.isSnapshot = isSnapshot;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return String.format("%d.%d.%d%s", this.major, this.minor, this.patch, this.isSnapshot ? "-SNAPSHOT" : "");
    }

    public static PomVersion parse(String str) {
        Iterable bits;
        boolean isSnapshot = false;
        String version = str;
        if (str.endsWith("-SNAPSHOT")) {
            isSnapshot = true;
            version = version.substring(0, str.length() - 9);
        }
        if (Iterables.size((Iterable)(bits = Splitter.on((String)".").split((CharSequence)version))) != 3) {
            throw new RuntimeException("Version string format is invalid");
        }
        try {
            Integer newMajor = Integer.valueOf((String)Iterables.get((Iterable)bits, (int)0));
            Integer newMinor = Integer.valueOf((String)Iterables.get((Iterable)bits, (int)1));
            Integer newPatch = Integer.valueOf((String)Iterables.get((Iterable)bits, (int)2));
            return new PomVersion(isSnapshot, newMajor, newMinor, newPatch);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Version portions are not numbers! " + str, e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isSnapshot ? 1231 : 1237);
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PomVersion other = (PomVersion)obj;
        if (this.isSnapshot != other.isSnapshot) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    @Override
    public int compareTo(@NotNull PomVersion pv) {
        return ComparisonChain.start().compare(this.major, pv.major).compare(this.minor, pv.minor).compare(this.patch, pv.patch).compareTrueFirst(this.isSnapshot, pv.isSnapshot).result();
    }
}

